package org.nuiton.topiatest.beangen;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

@Generated(value = "org.nuiton.eugene.java.BeanTransformer", date = "Mon Jan 27 13:46:52 CET 2020")
public abstract class GeneratedSiegeHelper {

    protected static final Function<Siege, Integer> NO_SERIE_FUNCTION = newNoSerieFunction();

    protected static final Function<Siege, Voiture> VOITURE_FUNCTION = newVoitureFunction();

    public static <BeanType extends Siege> Class<BeanType> typeOfSiege() {
        return (Class<BeanType>) Siege.class;
    }

    public static Siege newSiege() {
        return new Siege();
    }

    public static <BeanType extends Siege> BeanType newSiege(BeanType source) {
        Class<BeanType> sourceType = typeOfSiege();
        Binder<BeanType, BeanType> binder = BinderFactory.newBinder(sourceType);
        BeanType result = newSiege(source, binder);
        return result;
    }

    public static <BeanType extends Siege> BeanType newSiege(BeanType source, Binder<BeanType, BeanType> binder) {
        BeanType result = (BeanType) newSiege();
        binder.copy(source, result);
        return result;
    }

    public static <BeanType extends Siege> void copySiege(BeanType source, BeanType target) {
        Class<BeanType> sourceType = typeOfSiege();
        Binder<BeanType, BeanType> binder = BinderFactory.newBinder(sourceType);
        binder.copy(source, target);
    }

    public static <BeanType extends Siege> void copySiege(BeanType source, BeanType target, Binder<BeanType, BeanType> binder) {
        binder.copy(source, target);
    }

    public static <BeanType extends Siege> Predicate<BeanType> newNoSeriePredicate(int noSerie) {
        final int $tmp = noSerie;
        return new Predicate<BeanType>() {

            @Override
            public boolean apply(BeanType input) {
                return Objects.equal($tmp, input.getNoSerie());
            }
        };

    }

    public static <BeanType extends Siege> List<BeanType> filterByNoSerie(Collection<BeanType> $source, int noSerie) {
        return Lists.newArrayList(Iterables.filter($source, newNoSeriePredicate(noSerie)));
    }

    public static <BeanType extends Siege> Predicate<BeanType> newVoiturePredicate(Voiture voiture) {
        final Voiture $tmp = voiture;
        return new Predicate<BeanType>() {

            @Override
            public boolean apply(BeanType input) {
                return Objects.equal($tmp, input.getVoiture());
            }
        };

    }

    public static <BeanType extends Siege> List<BeanType> filterByVoiture(Collection<BeanType> $source, Voiture voiture) {
        return Lists.newArrayList(Iterables.filter($source, newVoiturePredicate(voiture)));
    }

    public static <BeanType extends Siege> Function<BeanType, Integer> getNoSerieFunction() {
        return (Function<BeanType, Integer>) NO_SERIE_FUNCTION;

    }

    public static <BeanType extends Siege> Function<BeanType, Integer> newNoSerieFunction() {
    return new Function<BeanType, Integer>() {

        @Override
        public Integer apply(BeanType input) {
            return input.getNoSerie();
        }
    };

}

    public static <BeanType extends Siege> ImmutableMap<Integer, BeanType> uniqueIndexByNoSerie(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, NO_SERIE_FUNCTION);
    }

    public static <BeanType extends Siege> Function<BeanType, Voiture> getVoitureFunction() {
        return (Function<BeanType, Voiture>) VOITURE_FUNCTION;

    }

    public static <BeanType extends Siege> Function<BeanType, Voiture> newVoitureFunction() {
    return new Function<BeanType, Voiture>() {

        @Override
        public Voiture apply(BeanType input) {
            return input.getVoiture();
        }
    };

}

    public static <BeanType extends Siege> ImmutableMap<Voiture, BeanType> uniqueIndexByVoiture(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, VOITURE_FUNCTION);
    }

} //GeneratedSiegeHelper
