/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.jdbc.Work;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

public abstract class TopiaSQLQuery<O> {
    protected abstract PreparedStatement prepareQuery(Connection var1) throws SQLException;

    protected abstract O prepareResult(ResultSet var1) throws SQLException;

    public O findSingleResult(TopiaContextImplementor tx) throws TopiaException {
        final ArrayList result = new ArrayList();
        tx.getHibernate().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                try (PreparedStatement ps = TopiaSQLQuery.this.prepareQuery(connection);){
                    ResultSet set = ps.executeQuery();
                    TopiaSQLQuery.this.findSingleResult(result, set);
                }
            }
        });
        return result.isEmpty() ? null : (O)result.get(0);
    }

    public List<O> findMultipleResult(TopiaContextImplementor tx) throws TopiaException {
        final ArrayList result = new ArrayList();
        tx.getHibernate().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                try (PreparedStatement ps = TopiaSQLQuery.this.prepareQuery(connection);){
                    ResultSet set = ps.executeQuery();
                    TopiaSQLQuery.this.findMultipleResult(result, set);
                }
            }
        });
        return result;
    }

    protected void afterExecuteQuery(ResultSet set) throws SQLException {
    }

    protected void findSingleResult(List<O> result, ResultSet set) throws SQLException {
        O singleResult;
        this.afterExecuteQuery(set);
        if (set.next() && (singleResult = this.prepareResult(set)) != null) {
            result.add(singleResult);
        }
    }

    protected void findMultipleResult(List<O> result, ResultSet set) throws SQLException {
        this.afterExecuteQuery(set);
        while (set.next()) {
            O singleResult = this.prepareResult(set);
            if (singleResult == null) continue;
            result.add(singleResult);
        }
    }

    protected String[] getColumnNames(ResultSet set) throws SQLException {
        ResultSetMetaData metaData = set.getMetaData();
        int columnCount = metaData.getColumnCount();
        String[] result = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            result[i] = metaData.getColumnName(i + 1);
        }
        return result;
    }

    protected long getNbRows(ResultSet set) throws SQLException {
        long nbRows = 0L;
        while (set.next()) {
            ++nbRows;
        }
        set.beforeFirst();
        return nbRows;
    }

    protected Map<String, Object> getRowAsMap(String[] columnNames, ResultSet set) throws SQLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            String name = columnNames[i];
            Object value = set.getObject(i + 1);
            result.put(name, value);
        }
        return result;
    }
}

