package org.nuiton.topia.it.mapping.test14;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;

public abstract class Assoc14BAbstract extends AbstractTopiaEntity implements Assoc14B {

    /**
     * Nom de l'attribut en BD : b14B
     */
    protected B14B b14B;

    /**
     * Nom de l'attribut en BD : roleA
     */
    protected A14B roleA;

    private static final long serialVersionUID = 3688556067646681396L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_B14_B, B14B.class, b14B);
        visitor.visit(this, PROPERTY_ROLE_A, A14B.class, roleA);
    }

    @Override
    public void setB14B(B14B b14B) {
        this.b14B = b14B;
    }

    @Override
    public B14B getB14B() {
        B14B result = this.b14B;
        return result;
    }

    @Override
    public void setRoleA(A14B roleA) {
        this.roleA = roleA;
    }

    @Override
    public A14B getRoleA() {
        A14B result = this.roleA;
        return result;
    }

} //Assoc14BAbstract
