package org.nuiton.topia.it.legacy.topiatest;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.it.legacy.AbstractTopiaItLegacyEntity;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class DepartmentAbstract extends AbstractTopiaItLegacyEntity implements Department {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : leader
     */
    protected Employe leader;

    /**
     * Nom de l'attribut en BD : company
     */
    protected Company company;

    /**
     * Nom de l'attribut en BD : product
     */
    protected Collection<Product> product;

    private static final long serialVersionUID = 4120851041491432033L;

    static {
    
        I18n.n("topia.test.common.department");
        I18n.n("topia.test.common.name");
        I18n.n("topia.test.common.leader");
        I18n.n("topia.test.common.company");
        I18n.n("topia.test.common.product");
    }

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_LEADER, Employe.class, leader);
        visitor.visit(this, PROPERTY_COMPANY, Company.class, company);
        visitor.visit(this, PROPERTY_PRODUCT, Collection.class, Product.class, product);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setLeader(Employe leader) {
        Employe oldValue = this.leader;
        fireOnPreWrite(PROPERTY_LEADER, oldValue, leader);
        this.leader = leader;
        fireOnPostWrite(PROPERTY_LEADER, oldValue, leader);
    }

    @Override
    public Employe getLeader() {
        fireOnPreRead(PROPERTY_LEADER, leader);
        Employe result = this.leader;
        fireOnPostRead(PROPERTY_LEADER, leader);
        return result;
    }

    @Override
    public void setCompany(Company company) {
        Company oldValue = this.company;
        fireOnPreWrite(PROPERTY_COMPANY, oldValue, company);
        this.company = company;
        fireOnPostWrite(PROPERTY_COMPANY, oldValue, company);
    }

    @Override
    public Company getCompany() {
        fireOnPreRead(PROPERTY_COMPANY, company);
        Company result = this.company;
        fireOnPostRead(PROPERTY_COMPANY, company);
        return result;
    }

    @Override
    public void addProduct(Product product) {
        fireOnPreWrite(PROPERTY_PRODUCT, null, product);
        if (this.product == null) {
            this.product = new LinkedList<Product>();
        }
        this.product.add(product);
        fireOnPostWrite(PROPERTY_PRODUCT, this.product.size(), null, product);
    }

    @Override
    public void addAllProduct(Iterable<Product> product) {
        if (product == null) {
            return;
        }
        for (Product item : product) {
            addProduct(item);
        }
    }

    @Override
    public void setProduct(Collection<Product> product) {
        // Copy elements to keep data for fire with new reference
        Collection<Product> oldValue = this.product != null ? new LinkedList<Product>(this.product) : null;
        fireOnPreWrite(PROPERTY_PRODUCT, oldValue, product);
        this.product = product;
        fireOnPostWrite(PROPERTY_PRODUCT, oldValue, product);
    }

    @Override
    public void removeProduct(Product product) {
        fireOnPreWrite(PROPERTY_PRODUCT, product, null);
        if (this.product == null || !this.product.remove(product)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(PROPERTY_PRODUCT, this.product.size() + 1, product, null);
    }

    @Override
    public void clearProduct() {
        if (this.product == null) {
            return;
        }
        Collection<Product> oldValue = new LinkedList<Product>(this.product);
        fireOnPreWrite(PROPERTY_PRODUCT, oldValue, this.product);
        this.product.clear();
        fireOnPostWrite(PROPERTY_PRODUCT, oldValue, this.product);
    }

    @Override
    public Collection<Product> getProduct() {
        return product;
    }

    @Override
    public Product getProductByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(product, topiaId);
    }

    @Override
    public Collection<String> getProductTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<org.nuiton.topia.it.legacy.topiatest.Product> tmp = getProduct();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeProduct() {
        if (product == null) {
            return 0;
        }
        return product.size();
    }

    @Override
    public boolean isProductEmpty() {
        int size = sizeProduct();
        return size == 0;
    }

    @Override
    public boolean isProductNotEmpty() {
        boolean empty = isProductEmpty();
        return ! empty;
    }

    @Override
    public boolean containsProduct(Product product) {
        boolean contains = this.product !=null && this.product.contains(product);
        return contains;
    }

} //DepartmentAbstract
