package org.nuiton.topia.it.legacy.topiatest;

/*
 * #%L
 * ToPIA :: IT
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.it.legacy.AbstractTopiaItLegacyDao;
import org.nuiton.topia.it.legacy.TopiaItLegacyEntityEnum;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Mon Jul 21 16:58:26 CEST 2014")
public abstract class GeneratedNaturalizedEntityTopiaDao<E extends NaturalizedEntity> extends AbstractTopiaItLegacyDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) NaturalizedEntity.class;
    }

    @Override
    public TopiaItLegacyEntityEnum getTopiaEntityEnum() {
        return TopiaItLegacyEntityEnum.NaturalizedEntity;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(Integer naturalIdNotNull, String naturalIdNull) {
        return forProperties(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(Integer naturalIdNotNull, String naturalIdNull) {
        return forProperties(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull).exists();
    }

    public E createByNaturalId(Integer naturalIdNotNull, String naturalIdNull) {
        return create(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(Integer naturalIdNotNull, String naturalIdNull) {
        return forProperties(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

    public E createByNotNull(Integer naturalIdNotNull) {
        return create(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNaturalIdNotNullIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNaturalIdNotNullEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, v);
        return result;
    }

    @Deprecated
    public E findByNaturalIdNotNull(Integer v) {
        return forNaturalIdNotNullEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByNaturalIdNotNull(Integer v) {
        return forNaturalIdNotNullEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNaturalIdNullIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNaturalIdNullEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, v);
        return result;
    }

    @Deprecated
    public E findByNaturalIdNull(String v) {
        return forNaturalIdNullEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByNaturalIdNull(String v) {
        return forNaturalIdNullEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedNaturalizedEntityTopiaDao<E extends NaturalizedEntity>
