package org.nuiton.topia.it.legacy.test.entities;

/*
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.it.legacy.AbstractTopiaItLegacyEntity;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Fri Jan 23 15:51:34 UTC 2015")
public abstract class PersonAbstract extends AbstractTopiaItLegacyEntity implements Person {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : firstname
     */
    protected String firstname;

    /**
     * Nom de l'attribut en BD : pet
     */
    protected Collection<Pet> pet;

    private static final long serialVersionUID = 3979040660960470069L;

    static {
    
        I18n.n("topia.test.common.person");
        I18n.n("topia.test.common.name");
        I18n.n("topia.test.common.firstname");
        I18n.n("topia.test.common.pet");
    }

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_FIRSTNAME, String.class, firstname);
        visitor.visit(this, PROPERTY_PET, Collection.class, Pet.class, pet);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setFirstname(String firstname) {
        String oldValue = this.firstname;
        fireOnPreWrite(PROPERTY_FIRSTNAME, oldValue, firstname);
        this.firstname = firstname;
        fireOnPostWrite(PROPERTY_FIRSTNAME, oldValue, firstname);
    }

    @Override
    public String getFirstname() {
        fireOnPreRead(PROPERTY_FIRSTNAME, firstname);
        String result = this.firstname;
        fireOnPostRead(PROPERTY_FIRSTNAME, firstname);
        return result;
    }

    @Override
    public void addPet(Pet pet) {
        fireOnPreWrite(PROPERTY_PET, null, pet);
        if (this.pet == null) {
            this.pet = new LinkedList<Pet>();
        }
        pet.setPerson(this);
        this.pet.add(pet);
        fireOnPostWrite(PROPERTY_PET, this.pet.size(), null, pet);
    }

    @Override
    public void addAllPet(Iterable<Pet> pet) {
        if (pet == null) {
            return;
        }
        for (Pet item : pet) {
            addPet(item);
        }
    }

    @Override
    public void setPet(Collection<Pet> pet) {
        // Copy elements to keep data for fire with new reference
        Collection<Pet> oldValue = this.pet != null ? new LinkedList<Pet>(this.pet) : null;
        fireOnPreWrite(PROPERTY_PET, oldValue, pet);
        this.pet = pet;
        fireOnPostWrite(PROPERTY_PET, oldValue, pet);
    }

    @Override
    public void removePet(Pet pet) {
        fireOnPreWrite(PROPERTY_PET, pet, null);
        if (this.pet == null || !this.pet.remove(pet)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        pet.setPerson(null);
        fireOnPostWrite(PROPERTY_PET, this.pet.size() + 1, pet, null);
    }

    @Override
    public void clearPet() {
        if (this.pet == null) {
            return;
        }
        for (Pet item : this.pet) {
            item.setPerson(null);
        }
        Collection<Pet> oldValue = new LinkedList<Pet>(this.pet);
        fireOnPreWrite(PROPERTY_PET, oldValue, this.pet);
        this.pet.clear();
        fireOnPostWrite(PROPERTY_PET, oldValue, this.pet);
    }

    @Override
    public Collection<Pet> getPet() {
        return pet;
    }

    @Override
    public Pet getPetByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(pet, topiaId);
    }

    @Override
    public Collection<String> getPetTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<org.nuiton.topia.it.legacy.test.entities.Pet> tmp = getPet();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizePet() {
        if (pet == null) {
            return 0;
        }
        return pet.size();
    }

    @Override
    public boolean isPetEmpty() {
        int size = sizePet();
        return size == 0;
    }

    @Override
    public boolean isPetNotEmpty() {
        boolean empty = isPetEmpty();
        return ! empty;
    }

    @Override
    public boolean containsPet(Pet pet) {
        boolean contains = this.pet !=null && this.pet.contains(pet);
        return contains;
    }

} //PersonAbstract
