/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRI;

import java.util.Vector;
import org.rosuda.JRI.RBool;
import org.rosuda.JRI.RFactor;
import org.rosuda.JRI.RList;
import org.rosuda.JRI.RVector;
import org.rosuda.JRI.Rengine;

public class REXP {
    public static final int XT_NULL = 0;
    public static final int XT_INT = 1;
    public static final int XT_DOUBLE = 2;
    public static final int XT_STR = 3;
    public static final int XT_LANG = 4;
    public static final int XT_SYM = 5;
    public static final int XT_BOOL = 6;
    public static final int XT_VECTOR = 16;
    public static final int XT_LIST = 17;
    public static final int XT_CLOS = 18;
    public static final int XT_ARRAY_INT = 32;
    public static final int XT_ARRAY_DOUBLE = 33;
    public static final int XT_ARRAY_STR = 34;
    public static final int XT_ARRAY_BOOL_UA = 35;
    public static final int XT_ARRAY_BOOL = 36;
    public static final int XT_ARRAY_BOOL_INT = 37;
    public static final int XT_UNKNOWN = 48;
    public static final int XT_NONE = -1;
    public static final int XT_FACTOR = 127;
    public static final int NILSXP = 0;
    public static final int SYMSXP = 1;
    public static final int LISTSXP = 2;
    public static final int CLOSXP = 3;
    public static final int ENVSXP = 4;
    public static final int PROMSXP = 5;
    public static final int LANGSXP = 6;
    public static final int SPECIALSXP = 7;
    public static final int BUILTINSXP = 8;
    public static final int CHARSXP = 9;
    public static final int LGLSXP = 10;
    public static final int INTSXP = 13;
    public static final int REALSXP = 14;
    public static final int CPLXSXP = 15;
    public static final int STRSXP = 16;
    public static final int DOTSXP = 17;
    public static final int ANYSXP = 18;
    public static final int VECSXP = 19;
    public static final int EXPRSXP = 20;
    public static final int BCODESXP = 21;
    public static final int EXTPTRSXP = 22;
    public static final int WEAKREFSXP = 23;
    public static final int RAWSXP = 24;
    public static final int S4SXP = 25;
    public static final int FUNSXP = 99;
    Rengine eng;
    public long xp;
    public int rtype;
    int Xt;
    REXP attr;
    Object cont;
    long cachedBinaryLength = -1L;

    public REXP(Rengine re, long exp) {
        this(re, exp, true);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.Xt == -1 && this.xp != 0L && this.eng != null) {
                this.eng.rniRelease(this.xp);
            }
        }
        finally {
            super.finalize();
        }
    }

    public REXP(Rengine re, long exp, boolean convert) {
        this.eng = re;
        this.xp = exp;
        this.rtype = re.rniExpType(this.xp);
        if (!convert) {
            this.Xt = -1;
            if (re != null && this.xp != 0L) {
                re.rniPreserve(this.xp);
            }
            return;
        }
        if (this.rtype == 16) {
            String[] s = re.rniGetStringArray(this.xp);
            if (s != null && s.length == 1) {
                this.cont = s[0];
                this.Xt = 3;
            } else {
                this.cont = s;
                this.Xt = 34;
            }
        } else if (this.rtype == 13) {
            long levx;
            this.cont = null;
            if (re.rniInherits(this.xp, "factor") && (levx = re.rniGetAttr(this.xp, "levels")) != 0L) {
                String[] levels = null;
                int rlt = re.rniExpType(levx);
                if (rlt == 16) {
                    levels = re.rniGetStringArray(levx);
                    int[] ids = re.rniGetIntArray(this.xp);
                    this.cont = new RFactor(ids, levels, 1);
                    this.Xt = 127;
                }
            }
            if (this.cont == null) {
                this.cont = re.rniGetIntArray(this.xp);
                this.Xt = 32;
            }
        } else if (this.rtype == 14) {
            this.cont = re.rniGetDoubleArray(this.xp);
            this.Xt = 33;
        } else if (this.rtype == 10) {
            this.cont = re.rniGetBoolArrayI(this.xp);
            this.Xt = 37;
        } else if (this.rtype == 19) {
            long[] l = re.rniGetVector(this.xp);
            this.cont = new RVector();
            int i = 0;
            this.Xt = 16;
            while (i < l.length) {
                ((RVector)this.cont).addElement(new REXP(re, l[i++]));
            }
            long na = re.rniGetAttr(this.xp, "names");
            if (na != 0L && re.rniExpType(na) == 16) {
                ((RVector)this.cont).setNames(re.rniGetStringArray(na));
            }
        } else if (this.rtype == 2) {
            long car = re.rniCAR(this.xp);
            long cdr = re.rniCDR(this.xp);
            long tag = re.rniTAG(this.xp);
            REXP cdrx = cdr == 0L || re.rniExpType(cdr) != 2 ? null : new REXP(re, re.rniCDR(this.xp));
            this.cont = new RList(new REXP(re, car), tag == 0L ? null : new REXP(re, tag), cdrx);
            this.Xt = 17;
        } else if (this.rtype == 1) {
            this.cont = re.rniGetSymbolName(this.xp);
            this.Xt = 5;
        } else {
            this.Xt = 0;
        }
    }

    public REXP() {
        this.Xt = 0;
        this.attr = null;
        this.cont = null;
    }

    public REXP(int t, Object o) {
        this.Xt = t;
        this.cont = o;
        this.attr = null;
    }

    public REXP(int t, Object o, REXP at) {
        this.Xt = t;
        this.cont = o;
        this.attr = at;
    }

    public REXP(double[] val) {
        this(33, val);
    }

    public REXP(int[] val) {
        this(32, val);
    }

    public REXP(String[] val) {
        this(34, val);
    }

    public REXP(boolean[] val) {
        this.Xt = 37;
        if (val == null) {
            this.cont = new int[0];
        } else {
            int[] ic = new int[val.length];
            for (int i = 0; i < val.length; ++i) {
                ic[i] = val[i] ? 1 : 0;
            }
            this.cont = ic;
        }
        this.attr = null;
    }

    public REXP getAttributes() {
        return this.attr;
    }

    public REXP getAttribute(String name) {
        long aref = this.eng.rniGetAttr(this.xp, name);
        if (aref == 0L) {
            return null;
        }
        return new REXP(this.eng, aref, this.Xt != -1);
    }

    public Object getContent() {
        return this.cont;
    }

    public int getType() {
        return this.Xt;
    }

    Rengine getEngine() {
        return this.eng;
    }

    public String asString() {
        if (this.cont == null) {
            return null;
        }
        if (this.Xt == 3) {
            return (String)this.cont;
        }
        if (this.Xt == 34) {
            String[] sa = (String[])this.cont;
            return sa.length > 0 ? sa[0] : null;
        }
        return null;
    }

    public String asSymbolName() {
        return this.Xt == 5 ? (String)this.cont : null;
    }

    public String[] asStringArray() {
        if (this.cont == null) {
            return null;
        }
        if (this.Xt == 3) {
            String[] sa = new String[]{(String)this.cont};
            return sa;
        }
        if (this.Xt == 34) {
            return (String[])this.cont;
        }
        return null;
    }

    public int asInt() {
        int[] i;
        if (this.Xt == 32 && (i = (int[])this.cont) != null && i.length > 0) {
            return i[0];
        }
        return this.Xt == 1 ? (Integer)this.cont : 0;
    }

    public double asDouble() {
        double[] d;
        if (this.Xt == 33 && (d = (double[])this.cont) != null && d.length > 0) {
            return d[0];
        }
        return this.Xt == 2 ? (Double)this.cont : 0.0;
    }

    public RVector asVector() {
        return this.Xt == 16 ? (RVector)this.cont : null;
    }

    public RFactor asFactor() {
        return this.Xt == 127 ? (RFactor)this.cont : null;
    }

    public RList asList() {
        return this.Xt == 17 ? (RList)this.cont : (this.Xt == 16 ? new RList((RVector)this.cont) : null);
    }

    public RBool asBool() {
        if (this.Xt == 37) {
            int[] ba = (int[])this.cont;
            return ba != null && ba.length > 0 ? new RBool(ba[0]) : null;
        }
        return this.Xt == 6 ? (RBool)this.cont : null;
    }

    public double[] asDoubleArray() {
        if (this.Xt == 33) {
            return (double[])this.cont;
        }
        if (this.Xt == 2) {
            double[] d = new double[]{this.asDouble()};
            return d;
        }
        if (this.Xt == 1) {
            double[] d = new double[]{((Integer)this.cont).doubleValue()};
            return d;
        }
        if (this.Xt == 32) {
            int[] i = this.asIntArray();
            if (i == null) {
                return null;
            }
            double[] d = new double[i.length];
            for (int j = 0; j < i.length; ++j) {
                d[j] = i[j];
            }
            return d;
        }
        return null;
    }

    public int[] asIntArray() {
        if (this.Xt == 32 || this.Xt == 37) {
            return (int[])this.cont;
        }
        if (this.Xt == 1) {
            int[] i = new int[]{this.asInt()};
            return i;
        }
        return null;
    }

    public double[][] asDoubleMatrix() {
        double[] ct = this.asDoubleArray();
        if (ct == null) {
            return null;
        }
        REXP dim = this.getAttribute("dim");
        if (dim == null || dim.Xt != 32) {
            return null;
        }
        int[] ds = dim.asIntArray();
        if (ds == null || ds.length != 2) {
            return null;
        }
        int m = ds[0];
        int n = ds[1];
        double[][] r = new double[m][n];
        if (ct == null) {
            return null;
        }
        int k = 0;
        for (int i = 0; i < n; ++i) {
            int j = 0;
            while (j < m) {
                r[j++][i] = ct[k++];
            }
        }
        return r;
    }

    public double[][] asMatrix() {
        return this.asDoubleMatrix();
    }

    public String toString() {
        int i;
        Object[] d;
        StringBuffer sb = new StringBuffer("[" + REXP.xtName(this.Xt) + " ");
        if (this.attr != null) {
            sb.append("\nattr=" + this.attr + "\n ");
        }
        if (this.Xt == 2) {
            sb.append((Double)this.cont);
        }
        if (this.Xt == 1) {
            sb.append((Integer)this.cont);
        }
        if (this.Xt == 6) {
            sb.append((RBool)this.cont);
        }
        if (this.Xt == 127) {
            sb.append((RFactor)this.cont);
        }
        if (this.Xt == 33) {
            d = (double[])this.cont;
            sb.append("(");
            for (i = 0; i < d.length; ++i) {
                sb.append(d[i]);
                if (i < d.length - 1) {
                    sb.append(", ");
                }
                if (i != 99) continue;
                sb.append("... (" + (d.length - 100) + " more values follow)");
                break;
            }
            sb.append(")");
        }
        if (this.Xt == 32) {
            d = (int[])this.cont;
            sb.append("(");
            for (i = 0; i < d.length; ++i) {
                sb.append((int)d[i]);
                if (i < d.length - 1) {
                    sb.append(", ");
                }
                if (i != 99) continue;
                sb.append("... (" + (d.length - 100) + " more values follow)");
                break;
            }
            sb.append(")");
        }
        if (this.Xt == 36) {
            d = (RBool[])this.cont;
            sb.append("(");
            for (i = 0; i < d.length; ++i) {
                sb.append((Object)d[i]);
                if (i >= d.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        if (this.Xt == 34) {
            d = (String[])this.cont;
            sb.append("(");
            for (i = 0; i < d.length; ++i) {
                sb.append(d[i] == null ? "NA" : "\"" + (String)d[i] + "\"");
                if (i < d.length - 1) {
                    sb.append(", ");
                }
                if (i != 10 || d.length <= 14) continue;
                sb.append("... (" + (d.length - 10) + " more values follow)");
                break;
            }
            sb.append(")");
        }
        if (this.Xt == 16) {
            Vector v = (Vector)this.cont;
            sb.append("(");
            for (i = 0; i < v.size(); ++i) {
                sb.append(((REXP)v.elementAt(i)).toString());
                if (i >= v.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        if (this.Xt == 3) {
            if (this.cont == null) {
                sb.append("NA");
            } else {
                sb.append("\"");
                sb.append((String)this.cont);
                sb.append("\"");
            }
        }
        if (this.Xt == 5) {
            sb.append((String)this.cont);
        }
        if (this.Xt == 17 || this.Xt == 4) {
            RList l = (RList)this.cont;
            sb.append(l.head);
            sb.append(":");
            sb.append(l.tag);
            sb.append(",(");
            sb.append(l.body);
            sb.append(")");
        }
        if (this.Xt == -1) {
            sb.append("{" + this.rtype + "}");
        }
        if (this.Xt == 48) {
            sb.append((Integer)this.cont);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String quoteString(String s) {
        if (s.indexOf(92) >= 0) {
            s.replaceAll("\\", "\\\\");
        }
        if (s.indexOf(34) >= 0) {
            s.replaceAll("\"", "\\\"");
        }
        return "\"" + s + "\"";
    }

    public static String xtName(int xt) {
        if (xt == 0) {
            return "NULL";
        }
        if (xt == 1) {
            return "INT";
        }
        if (xt == 3) {
            return "STRING";
        }
        if (xt == 2) {
            return "REAL";
        }
        if (xt == 6) {
            return "BOOL";
        }
        if (xt == 32) {
            return "INT*";
        }
        if (xt == 34) {
            return "STRING*";
        }
        if (xt == 33) {
            return "REAL*";
        }
        if (xt == 36) {
            return "BOOL*";
        }
        if (xt == 37) {
            return "BOOLi*";
        }
        if (xt == 5) {
            return "SYMBOL";
        }
        if (xt == 4) {
            return "LANG";
        }
        if (xt == 17) {
            return "LIST";
        }
        if (xt == 18) {
            return "CLOS";
        }
        if (xt == 16) {
            return "VECTOR";
        }
        if (xt == 127) {
            return "FACTOR";
        }
        if (xt == 48) {
            return "UNKNOWN";
        }
        if (xt == -1) {
            return "(SEXP)";
        }
        return "<unknown " + xt + ">";
    }
}

