package org.nuiton.spgeed.query;

/*-
 * #%L
 * spgeed
 * %%
 * Copyright (C) 2017 - 2020 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

public class QueryFacetValue extends QueryFacet {

    /**
     * can be simply the field name: myfield
     * or sql expression: unnest(myarrayfield)
     * or sql date expression: date_trunc('month', mydatefield)
     * or sql date expression: date_part('month', mydatefield)
     */
    protected String valueExtractor;

    public QueryFacetValue(String name, String valueExtractor) {
        super(name);
        this.valueExtractor = valueExtractor;
    }

    @Override
    public String getQuery(String tableSource) {
        return String.format("select %s as topic, count(*) as count from %s group by topic order by %s, topic limit %s", valueExtractor, tableSource, getSort().getSortClause(), getMax());
    }
}
