package org.nuiton.spgeed.query;

/*-
 * #%L
 * spgeed
 * %%
 * Copyright (C) 2017 - 2020 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

public abstract class QueryFacet {

    /** facet name */
    protected String name;
    /**
     * maximum topic to retrieve
     */
    protected int max = 10;
    protected FacetSortOrder sort = FacetSortOrder.COUNT_ASC;

    public QueryFacet(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public int getMax() {
        return max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public FacetSortOrder getSort() {
        return sort;
    }

    public void setSort(FacetSortOrder sort) {
        this.sort = sort;
    }

    /**
     * retourne la requete SQL qui retourne le calcul pour cette facette
     * @param tableSource le nom de la vue dans lequel sont les resultats
     */
    abstract public String getQuery(String tableSource);
}
