package org.nuiton.spgeed;

/*-
 * #%L
 * spgeed
 * %%
 * Copyright (C) 2017 - 2020 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.spgeed.query.QueryFacets;

import java.sql.ResultSet;
import java.util.Optional;

public interface SpgeedMapper {

    /**
     *
     * @param sql primitive sql query
     * @param chunk previous chunk used to create next call
     * @param roleContraints contraint on role need by user
     * @return sql converted for this mapper
     */
    String getSql(AnnotationProvider annotationProvider, String sql, Optional<Chunk> chunk, QueryFacets facets, Optional<String> roleContraints);

    /**
     *
     * @param rs ResultSet to transform
     * @param returnType wanted final type
     * @param elementType element type if returnType is collection or array
     * @return new object of returnType Class
     * @throws Exception if error during conversion
     */
    <E> E getResult(AnnotationProvider annotationProvider, ResultSet rs, Class<E> returnType, Class elementType) throws Exception;
}
