package org.nuiton.spgeed;

/*-
 * #%L
 * spgeed
 * %%
 * Copyright (C) 2017 - 2020 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;

public interface Chunk<T> extends Collection<T>, Facets {
    static Chunk init(long fetch) {
        Chunk result = new ChunkArrayList(fetch, 0, 0, 0);
        return result;
    }

    static Chunk restart(long fetch, long last) {
        Chunk result = new ChunkArrayList(fetch, 0, last, 0);
        return result;
    }

    default Collection<T> getResult() {
        return this;
    }


    default void set(Class<T> elementType, long fetch, long first, long next, long total) {
        setElementType(elementType);
        setFetch(fetch);
        setFirst(first);
        setNext(next);
        setTotal(total);
    }

    Class<T> getElementType();

    Chunk<T> setElementType(Class<T> elementType);

    long getFetch();

    Chunk<T> setFetch(long fetch);

    long getFirst();

    Chunk<T> setFirst(long first);

    long getNext();

    Chunk<T> setNext(long next);

    long getTotal();

    Chunk<T> setTotal(long total);

}
