/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.spgeed.mapper.simpleflatmapper;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.spgeed.AnnotationProvider;
import org.nuiton.spgeed.Chunk;
import org.nuiton.spgeed.ChunkArrayList;
import org.nuiton.spgeed.SpgeedMapper;
import org.nuiton.spgeed.SpgeedUtils;
import org.nuiton.spgeed.mapper.simpleflatmapper.SimpleFlatMapperConfig;
import org.postgresql.PGResultSetMetaData;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;

public class SimpleFlatMapper
implements SpgeedMapper {
    private static final String FETCH_RESULT_ALIAS = "__fetch";
    private static final String FIRST_RESULT_ALIAS = "__first";
    private static final String NEXT_RESULT_ALIAS = "__next";
    private static final String TOTAL_RESULT_ALIAS = "__total";

    @Override
    public String getSql(AnnotationProvider annotationProvider, String sql, Optional<Chunk> optChunk, Optional<String> roleContraints) {
        String result;
        String formattedRoles = roleContraints.map(r -> "WHERE " + r).orElse("");
        if (optChunk.isPresent()) {
            Chunk chunk = optChunk.get();
            result = String.format("WITH __all AS (%s) select g.*, %s as %s, -1+min(g.__num__) over() as %s, -1+max(g.__num__) over() as %s, from (select *, row_number() over () as __num__, count(*) over () as %s  from __all %s LIMIT %s OFFSET %s) g", sql, chunk.getFetch(), FETCH_RESULT_ALIAS, FIRST_RESULT_ALIAS, NEXT_RESULT_ALIAS, TOTAL_RESULT_ALIAS, formattedRoles, chunk.getFetch(), chunk.getNext());
        } else {
            result = String.format("WITH __all AS (%s) SELECT __all.* FROM __all %s", sql, formattedRoles);
        }
        return result;
    }

    @Override
    public <E> E getResult(AnnotationProvider annotationProvider, ResultSet rs, Class<E> returnType, Class elementType) throws Exception {
        SimpleFlatMapperConfig config = annotationProvider.getAnnotation(SimpleFlatMapperConfig.class);
        String[] ids = config.ids();
        EnhanceResultSetMetaData metaData = (EnhanceResultSetMetaData)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EnhanceResultSetMetaData.class}, (InvocationHandler)new ResultSetMetaDataHandler(rs.getMetaData(), elementType, ids));
        JdbcMapper mapper = ((JdbcMapperFactory)((JdbcMapperFactory)JdbcMapperFactory.newInstance().addKeys(metaData.getAllColumnUid())).ignorePropertyNotFound()).newMapper(elementType, (ResultSetMetaData)metaData);
        if (SpgeedUtils.returningChunk(returnType)) {
            EnhanceResultSet ers = (EnhanceResultSet)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EnhanceResultSet.class}, (InvocationHandler)new ResultSetHandler(rs));
            return (E)mapper.stream((ResultSet)ers).collect(Collectors.toCollection(() -> ers.getChunk(returnType, elementType)));
        }
        if (SpgeedUtils.returningCollection(returnType)) {
            return (E)mapper.stream(rs).collect(Collectors.toCollection(() -> SpgeedUtils.newCollectionInstance(returnType)));
        }
        List<Object> result = mapper.stream(rs).collect(Collectors.toList());
        if (returnType.isArray()) {
            return (E)result.toArray((Object[])Array.newInstance(elementType, result.size()));
        }
        if (!result.isEmpty()) {
            return (E)result.get(0);
        }
        return null;
    }

    protected static class ResultSetMetaDataHandler
    implements InvocationHandler {
        protected ResultSetMetaData meta;
        protected Class returnType;
        protected String[] ids;
        protected String[] allColumnUid;
        protected Set<String> allTableName;

        public ResultSetMetaDataHandler(ResultSetMetaData meta, Class returnType, String[] ids) {
            this.meta = meta;
            this.returnType = returnType;
            this.ids = ids;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (StringUtils.equals((CharSequence)method.getName(), (CharSequence)"getColumnLabel")) {
                int columnIndex = (Integer)args[0];
                String result = this.getColumnLabel(columnIndex);
                return result;
            }
            if (StringUtils.equals((CharSequence)method.getName(), (CharSequence)"getAllColumnUid")) {
                return this.getAllColumnUid();
            }
            return method.invoke((Object)this.meta, args);
        }

        protected String[] getAllColumnUid() throws SQLException {
            if (this.allColumnUid == null) {
                HashSet<String> result = new HashSet<String>();
                int numCol = this.meta.getColumnCount();
                for (int i = 1; i <= numCol; ++i) {
                    if (!this.equalsIgnoreCase(this.meta.getColumnLabel(i), this.ids)) continue;
                    result.add(this.getColumnLabel(i));
                }
                this.allColumnUid = result.toArray(new String[result.size()]);
            }
            return this.allColumnUid;
        }

        protected String getColumnLabel(int columnIndex) throws SQLException {
            String label = this.meta.getColumnLabel(columnIndex);
            String name = ((PGResultSetMetaData)this.meta).getBaseColumnName(columnIndex);
            String table = this.meta.getTableName(columnIndex);
            String result = !label.equalsIgnoreCase(name) ? label : (this.isTable(label) ? this.getTableIdColumn(label) : (this.returnType.getSimpleName().equalsIgnoreCase(table) ? label : table + "_" + label));
            return result;
        }

        protected String getTableIdColumn(String tableName) throws SQLException {
            String result = Stream.of(this.getAllColumnUid()).filter(v -> StringUtils.startsWith((CharSequence)v, (CharSequence)(tableName + "_"))).findAny().orElseThrow(() -> new IllegalArgumentException("Can't find id for table: " + tableName));
            return result;
        }

        protected boolean isTable(String name) throws SQLException {
            return this.getAllTableName().contains(name);
        }

        protected Set<String> getAllTableName() throws SQLException {
            if (this.allTableName == null) {
                HashSet<String> result = new HashSet<String>();
                int numCol = this.meta.getColumnCount();
                for (int i = 1; i <= numCol; ++i) {
                    result.add(this.meta.getTableName(i));
                }
                this.allTableName = result;
            }
            return this.allTableName;
        }

        protected boolean equalsIgnoreCase(String s, String ... m) {
            return Stream.of(m).anyMatch(v -> s.equalsIgnoreCase((String)v));
        }
    }

    protected static class ResultSetHandler
    implements InvocationHandler {
        protected ResultSet rs;
        protected Chunk chunk;

        public ResultSetHandler(ResultSet rs) {
            this.rs = rs;
        }

        public Chunk getChunk() {
            return this.chunk;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (StringUtils.equals((CharSequence)method.getName(), (CharSequence)"getChunk")) {
                return SpgeedUtils.newChunk((Class)Class.class.cast(args[0]), (Class)Class.class.cast(args[1]), this.chunk.getFetch(), this.chunk.getFirst(), this.chunk.getNext(), this.chunk.getTotal());
            }
            if (StringUtils.equals((CharSequence)method.getName(), (CharSequence)"next")) {
                boolean result = this.rs.next();
                if (result) {
                    this.chunk = this.createChunk(this.rs);
                }
                return result;
            }
            return method.invoke((Object)this.rs, args);
        }

        protected Chunk createChunk(ResultSet rs) throws SQLException {
            long fetch = rs.getLong(SimpleFlatMapper.FETCH_RESULT_ALIAS);
            long first = rs.getLong(SimpleFlatMapper.FIRST_RESULT_ALIAS);
            long next = rs.getLong(SimpleFlatMapper.NEXT_RESULT_ALIAS);
            long total = rs.getLong(SimpleFlatMapper.TOTAL_RESULT_ALIAS);
            ChunkArrayList result = new ChunkArrayList(fetch, first, next, total);
            return result;
        }
    }

    protected static interface EnhanceResultSet
    extends ResultSet {
        public <T, C extends Chunk<T>> C getChunk(Class<C> var1, Class<T> var2);
    }

    protected static interface EnhanceResultSetMetaData
    extends ResultSetMetaData {
        public String[] getAllColumnUid();
    }
}

