/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.spgeed;

import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jodd.bean.BeanException;
import jodd.bean.BeanUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.spgeed.AnnotationProvider;
import org.nuiton.spgeed.Chunk;
import org.nuiton.spgeed.PipeFunction;
import org.nuiton.spgeed.QueryParser;
import org.nuiton.spgeed.SpgeedUtils;
import org.nuiton.spgeed.SqlSession;
import org.nuiton.spgeed.mapper.JsonMapper;

public class Query {
    private static final Log log = LogFactory.getLog(Query.class);
    protected SqlSession session;
    protected String sql;
    protected Class mapper;
    protected AnnotationProvider annotationProvider;
    protected String[] roles;
    protected Map<String, Object> parameters;
    protected Class returnType;
    protected Class elementType;
    protected String parsedSql;
    protected List<Object> sqlParameters;

    public Query(SqlSession session, String sql, Class mapper, AnnotationProvider annotationProvider, String[] roles, Map<String, Object> parameters, Class<?> returnClass, Type returnType) throws Exception {
        this.session = session;
        this.sql = sql;
        this.mapper = mapper;
        this.annotationProvider = annotationProvider;
        this.roles = roles;
        this.parameters = parameters;
        this.returnType = returnClass;
        this.sqlParameters = new ArrayList<Object>();
        this.elementType = SpgeedUtils.getElementType(returnType).orElse(returnClass);
    }

    public Query(SqlSession session, String sql, Map<String, Object> parameters, Class<?> returnClass) throws Exception {
        this(session, sql, JsonMapper.class, type -> null, null, parameters, returnClass, returnClass);
    }

    public String getParsedSql() throws SQLException {
        if (this.parsedSql == null) {
            try {
                this.parsedSql = this.parseParameters(this.sql);
            }
            catch (Exception eee) {
                throw new SQLException("Can't parse sql: " + this.sql, eee);
            }
        }
        return this.parsedSql;
    }

    protected String parseParameters(String sql) throws Exception {
        String result = QueryParser.parse(sql, this);
        return result;
    }

    public Object evalField(String path) {
        Object result = this.evalField(this.parameters, path);
        return result;
    }

    public Object evalField(Object o, String path) {
        Object result = o;
        if (StringUtils.isNotBlank((CharSequence)path)) {
            String queue = path;
            int next = this.indexOfDot(queue);
            while (next >= 0 && result != null) {
                String prop = queue.substring(0, next);
                queue = queue.substring(next + 1);
                result = this.evalOneField(result, prop);
                next = this.indexOfDot(queue);
            }
            result = this.evalOneField(result, queue);
        }
        return result;
    }

    private Object evalOneField(Object o, String prop) {
        Object result = null;
        if (o != null) {
            try {
                result = BeanUtil.pojo.getProperty(o, prop);
            }
            catch (BeanException eee) {
                throw new RuntimeException(String.format("Can't find properties '%s' in '%s'", prop, o), eee);
            }
        }
        return result;
    }

    protected int indexOfDot(String name) {
        int len = name.length();
        boolean insideBracket = false;
        for (int ndx = 0; ndx < len; ++ndx) {
            char c = name.charAt(ndx);
            if (insideBracket) {
                if (c != ']') continue;
                insideBracket = false;
                continue;
            }
            if (c == '.') {
                return ndx;
            }
            if (c != '[') continue;
            insideBracket = true;
        }
        return -1;
    }

    public Object evalFunction(Object value, String name, List args) {
        try {
            Map<String, PipeFunction> pipeFunctions = this.session.getPipeFunctions();
            PipeFunction pipeFunction = pipeFunctions.get(name);
            if (pipeFunction == null) {
                throw new RuntimeException(String.format("Can find function for evalFunction(%s, '%s', %s)", value, name, args));
            }
            Object result = pipeFunction.function(this, value, args == null ? null : args.toArray());
            return result;
        }
        catch (Exception eee) {
            throw new RuntimeException(String.format("Error during evalFunction(%s, %s, %s)", value, name, args), eee);
        }
    }

    public String addSqlParameter(Object value) {
        this.sqlParameters.add(value);
        return "?";
    }

    public SqlSession getSession() {
        return this.session;
    }

    protected PreparedStatement getStatement(String sql) throws SQLException {
        Connection connection = this.session.getConnection();
        PreparedStatement statement = connection.prepareStatement(sql);
        int position = 1;
        for (Object arg : this.sqlParameters) {
            if (arg != null && arg.getClass().isEnum()) {
                statement.setObject(position++, arg.toString());
                continue;
            }
            statement.setObject(position++, arg);
        }
        return statement;
    }

    protected Optional<String> getFormattedRoles() {
        Optional<String> result = Optional.empty();
        if (this.roles != null && this.roles.length > 0) {
            String formattedRoles = Stream.of(this.roles).collect(Collectors.joining("', 'member') OR pg_has_role('", "pg_has_role('", "', 'member')"));
            result = Optional.of(formattedRoles);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public <E> E executeQuery() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <E> E executeUpdate() throws SQLException, Exception {
        if (this.sql.contains("RETURNING")) {
            return this.executeQuery();
        }
        String sql = this.getParsedSql();
        try (PreparedStatement statement = this.getStatement(sql);){
            Integer result;
            Integer n = result = Integer.valueOf(statement.executeUpdate());
            return (E)n;
        }
        catch (Exception eee) {
            log.error((Object)String.format("Can't execute query '%s' with args: %s", this.getParsedSql(), this.sqlParameters));
            throw eee;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() throws SQLException {
        String sql = this.getParsedSql();
        try (PreparedStatement statement = this.getStatement(sql);){
            boolean result;
            boolean bl = result = statement.execute();
            return bl;
        }
        catch (Exception eee) {
            log.error((Object)String.format("Can't execute query '%s' with args: %s", this.getParsedSql(), this.sqlParameters));
            throw eee;
        }
    }

    private static /* synthetic */ IllegalArgumentException lambda$executeQuery$2() {
        return new IllegalArgumentException("Missing Chunk parameter");
    }

    private static /* synthetic */ boolean lambda$executeQuery$1(Object p) {
        return p instanceof Chunk;
    }
}

