/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import javax.naming.AuthenticationException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.BlowfishCipherService;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.ScmWebEditorMainAction;

public class ViewDiffsAction
extends ScmWebEditorMainAction {
    private static final Log log = LogFactory.getLog(ViewDiffsAction.class);
    protected String fileContent;
    protected String revision1;
    protected String revision2;
    protected String error;

    public String getFileContent() {
        return this.fileContent;
    }

    public void setFileContent(String fileContent) {
        this.fileContent = fileContent;
    }

    public String getRevision1() {
        return this.revision1;
    }

    public void setRevision1(String revision1) {
        this.revision1 = revision1;
    }

    public String getRevision2() {
        return this.revision2;
    }

    public void setRevision2(String revision2) {
        this.revision2 = revision2;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String execute() {
        HttpSession session = this.request.getSession();
        String sessionId = session.getId();
        this.error = null;
        String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
        ScmProvider provider = ScmWebEditorConfig.getProvider((String)this.scmType);
        ScmConnection scmConn = provider.getConnection(this.address, pathToLocalRepos);
        String repositoryUUID = scmConn.getRepositoryId();
        if (repositoryUUID == null) {
            repositoryUUID = this.address.replace(' ', '_');
            repositoryUUID = Normalizer.normalize(repositoryUUID, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Login : " + this.username));
        }
        String usernamepwCookie = null;
        BlowfishCipherService bf = new BlowfishCipherService();
        byte[] privateKey = Base64.decode((String)ScmWebEditorConfig.getKey());
        if (this.request.getCookies() != null) {
            for (Cookie c : this.request.getCookies()) {
                if (!c.getName().equals(repositoryUUID)) continue;
                usernamepwCookie = c.getValue();
            }
        }
        if (usernamepwCookie != null) {
            String[] resCookie;
            String usernameDecode;
            block18: {
                usernameDecode = null;
                try {
                    usernameDecode = new String(bf.decrypt(Base64.decode(usernamepwCookie), privateKey).getBytes(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    if (!log.isErrorEnabled()) break block18;
                    log.error((Object)"Can not create a String with UTF-8 encoding");
                }
            }
            if (usernameDecode != null && (resCookie = usernameDecode.split(",")).length == 2) {
                this.username = resCookie[0];
                this.pw = resCookie[1];
            }
        }
        if (this.saveCookie && this.username != null && this.pw != null && !this.username.equals("") && !this.pw.equals("")) {
            Cookie authCookie = new Cookie(repositoryUUID, bf.encrypt((this.username + "," + this.pw).getBytes(), privateKey).toBase64());
            authCookie.setMaxAge(31536000);
            this.response.addCookie(authCookie);
        }
        String[] usernamePw = this.getUsernamePwFromSession(repositoryUUID, this.username, this.pw);
        this.username = usernamePw[0];
        this.pw = usernamePw[1];
        String name = this.username;
        String password = this.pw;
        if (name == null) {
            name = "anonymous";
        }
        if (password == null) {
            password = "anonymous";
        }
        try {
            File tempFile = scmConn.getDiffs(this.address, name, password, this.revision1, this.revision2);
            if (tempFile == null) {
                this.error = "error";
                return "error";
            }
            this.fileContent = FileUtils.readFileToString((File)tempFile);
        }
        catch (AuthenticationException e) {
            this.request.setAttribute("address", (Object)this.address);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Auth Fail ", (Throwable)e);
            }
            for (Cookie c : this.request.getCookies()) {
                if (!c.getName().equals(repositoryUUID)) continue;
                c.setMaxAge(0);
                this.response.addCookie(c);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Cookie supprim\u00e9");
            }
            this.getScmSession().delScmUser(repositoryUUID);
            this.error = "login";
            return "login";
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not read temp file for " + this.address), (Throwable)e);
            }
            this.error = "error";
            return "error";
        }
        return "success";
    }
}

