/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor;

import java.io.Console;
import org.nuiton.processor.Processor;
import org.nuiton.processor.ProcessorUtil;
import org.nuiton.processor.filters.ActiveLogsCodeFilter;
import org.nuiton.processor.filters.RemoveLogsCodeFilter;

public class LogsProcessor
extends Processor {
    private static final String REMOVE_ACTION = "remove";
    private static final String ACTIVE_ACTION = "active";

    public LogsProcessor(Action action) {
        switch (action) {
            case NoAction: {
                break;
            }
            case Logs: {
                this.setInputFilter(new ActiveLogsCodeFilter());
                break;
            }
            case NoLogsCode: {
                this.setInputFilter(new RemoveLogsCodeFilter());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Console console = System.console();
        String eol = System.getProperty("line.separator");
        if (args.length < 2) {
            console.printf("Give source and destination file, then action" + eol, new Object[0]);
            console.printf("Action may be remove or active (default is no action)" + eol, new Object[0]);
            return;
        }
        Action action = Action.NoAction;
        if (args.length > 2) {
            if (args[2].equals(REMOVE_ACTION)) {
                action = Action.NoLogsCode;
                console.printf("Removing logs code" + eol, new Object[0]);
            } else if (args[2].equals(ACTIVE_ACTION)) {
                action = Action.Logs;
                console.printf("Setting logs active" + eol, new Object[0]);
            }
        }
        if (action == Action.NoAction) {
            console.printf("No action taken" + eol, new Object[0]);
        }
        LogsProcessor processor = new LogsProcessor(action);
        ProcessorUtil.doProcess((Processor)processor, args[0], args[1], ProcessorUtil.DEFAULT_ENCODING);
    }

    public static enum Action {
        NoAction,
        Logs,
        NoLogsCode;

    }
}

