/*
 * #%L
 * Nuiton Processor :: Api
 * 
 * $Id: GeneratorTemplatesFilterIn.java 377 2011-02-03 10:40:42Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/processor/tags/processor-1.2.1/nuiton-processor/src/main/java/org/nuiton/processor/filters/GeneratorTemplatesFilterIn.java $
 * %%
 * Copyright (C) 2002 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */


/* *
 * GeneratorTemplatesFilterIn.java
 *
 * Created: 14 janv. 2004
 *
 * @author Benjamin Poussin <poussin@codelutin.com>
 * Copyright Code Lutin
 * @version $Revision: 377 $
 *
 * Mise a jour: $Date: 2011-02-03 11:40:42 +0100 (Thu, 03 Feb 2011) $
 * par : */

package org.nuiton.processor.filters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Le tag *) n'est substitué que s'il est a l'extérieur du tag <%=...%>ou
 * <%...%>
 */
public class GeneratorTemplatesFilterIn extends DefaultFilter { // GeneratorTemplatesFilterIn

    private static final Log log =
            LogFactory.getLog(GeneratorTemplatesFilterIn.class);

    GeneratorTemplatesFilter parent;

    protected String beginParenthese = EMPTY_STRING;

    protected String endParenthese = EMPTY_STRING;


    public GeneratorTemplatesFilterIn(GeneratorTemplatesFilter parent) {
        this.parent = parent;
    }

    /**
     * méthode appelée lorsqu'on a la chaîne entière entre le header et le
     * footer.
     *
     * @param ch la chaîne trouvé
     * @return ce qu'il faut écrire dans le fichier de sortie
     */
    @Override
    protected String performInFilter(String ch) {
        if (parent.writeParentheses) {
            beginParenthese = "(";
            endParenthese = ");";
        } else {
            beginParenthese = EMPTY_STRING;
            endParenthese = EMPTY_STRING;
        }
        if (ch.startsWith("=")) {
            return "\"+" + ch.substring(1) + "+\"";
        }
        return "\"" + endParenthese + ch + parent.getWriteString() +
               beginParenthese + "\"";
    }

    /**
     * Converti les fin de commentaire *) en fin normal de commentraire
     *
     * @param ch la chaine a convertir
     * @return la chaine convertie
     */
    protected String convertEndComment(String ch) {
        String result = ch.replaceAll("\\*\\)", "*/");
        return result;
    }

    /**
     * methode appele lorsqu'on a la chaine entiere a l'exterieur du
     * header/footer
     *
     * @param ch la chaine trouve
     * @return ce qu'il faut ecrire dans le fichier de sortie
     */
    @Override
    protected String performOutFilter(String ch) {
        if (parent.writeParentheses) {
            beginParenthese = "(";
            endParenthese = ");";
        } else {
            beginParenthese = EMPTY_STRING;
            endParenthese = EMPTY_STRING;
        }
        String result = convertEndComment(ch).replaceAll("\"", "\\\\\"")
                .replaceAll("(\r\n|\n|\r)",
                            "\\\\n\"" + endParenthese + "\n" +
                            parent.getWriteString() + beginParenthese + "\"");
        // it's important that \r\n is first in regexp.

        return result;
    }

    @Override
    protected String getHeader() {
        return "<%";
    }

    @Override
    protected String getFooter() {
        return "%>";
    }

} // GeneratorTemplatesFilterIn

