/*
 * *##% 
 * Nuiton Processor :: Api
 * Copyright (C) 2002 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.processor;

import org.nuiton.processor.filters.LicenseFilter;

import java.io.File;
import java.io.IOException;

/**
 * This class is a processor of source header.
 *
 * @author chemit
 * @see LicenseFilter
 */
public class LicenseProcessor extends Processor {

    protected LicenseFilter licenseFilter;

    public LicenseProcessor(String header) {
        licenseFilter = new LicenseFilter(header);
        setInputFilter(licenseFilter);
    }

    public LicenseFilter getLicenceFilter() {
        return licenseFilter;
    }

    public void process(File filein, File fileout) throws IOException {
        ProcessorUtil.doProcess(this, filein, fileout);
//        process(new FileReader(filein), new FileWriter(fileout));
    }
}

