/* *##% nuiton-processor - lib
 * Copyright (C) 2002 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */
package org.nuiton.processor.filters;

/**
 * Un filtre pour remplacer la license d'un fichier source java.
 * <p/>
 * fixme : il faut ne pas autoriser le process de fichier java qui ne sont pas valide selon le header - footer...
 *
 * @author chemit
 */
public class LicenseFilter extends DefaultFilter {

    public static final String HEADER = "*" + "#" + "#" + "%";
    public static final String FOOTER = "#" + "#" + "%" + "*";
    /**
     * la licence a insere dans le header du fichier source. Ce header est formatte en commentaire (chaque ligne
     * commence par un ' * ', sauf pour la premiere et derniere ligne).
     */
    protected String licenseHeader;

    /** flag pour indiquer si la licence a ete trouvee entre le header et le footer */
    protected boolean touched;

    public LicenseFilter(String licenseHeader) {
        this.licenseHeader = " " + licenseHeader + " ";
    }

    protected String performInFilter(String ch) {
        if (touched) {
            // on autorise pas deux process de la licence dans un fichier java
            throw new IllegalStateException("has find more than once the license processor tags in a file");
        }
        touched = true;
        return HEADER + licenseHeader + FOOTER;
    }

    protected String performOutFilter(String ch) {
        return ch;
    }

    protected String getHeader() {
        return HEADER;
    }

    protected String getFooter() {
        return FOOTER;
    }

    public boolean wasTouched() {
        return touched;
    }

    public void reset() {
        touched = false;
    }
}
