/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.nuiton.io.MirroredFileUpdater;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginWithEncoding;
import org.nuiton.processor.Processor;
import org.nuiton.processor.ProcessorUtil;

public class ProcessorPlugin
extends AbstractPlugin
implements PluginWithEncoding {
    protected MavenProject project;
    protected File srcDir;
    protected File destDir;
    protected String includes;
    protected String excludes;
    protected String fileInPattern = "";
    protected String fileOutPattern = "";
    protected String filters;
    private String encoding;
    protected boolean overwrite;
    protected boolean verbose;
    protected boolean testPhase;
    protected Map<String, String> filesToTreate;

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected void init() throws Exception {
        MirroredFileUpdater updater;
        if (this.filters.isEmpty()) {
            return;
        }
        MirroredFileUpdater mirroredFileUpdater = updater = this.overwrite ? null : new MirroredFileUpdater(this.fileInPattern, this.fileOutPattern, this.srcDir, this.destDir);
        if (updater != null) {
            updater.setDestinationDirectory(this.destDir);
        }
        String[] aIncludes = this.includes.split(",");
        String[] aExcludes = this.excludes == null ? null : this.excludes.split(",");
        this.filesToTreate = this.getFilesToTreate(aIncludes, aExcludes, this.srcDir, updater);
    }

    protected boolean checkSkip() {
        if (this.filters.isEmpty()) {
            this.getLog().warn((CharSequence)"No filters to use, skip execution.");
            return false;
        }
        if (this.filesToTreate == null || this.filesToTreate.isEmpty()) {
            this.getLog().info((CharSequence)"No file to process.");
            return false;
        }
        return true;
    }

    protected void doAction() throws Exception {
        if (this.isVerbose()) {
            this.printConfig();
        }
        long t0 = System.nanoTime();
        Processor processor = ProcessorUtil.newProcessor((String)this.filters, (String)",");
        this.getLog().info((CharSequence)("Processing " + this.filesToTreate.size() + " files(s)."));
        for (Map.Entry<String, String> entry : this.filesToTreate.entrySet()) {
            File srcFile = new File(this.srcDir, entry.getKey());
            File dstFile = new File(entry.getValue());
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Process " + srcFile));
            }
            this.createDirectoryIfNecessary(dstFile.getParentFile());
            ProcessorUtil.doProcess((Processor)processor, (File)srcFile, (File)dstFile, (String)this.getEncoding());
        }
        if (this.isVerbose()) {
            long time = System.nanoTime() - t0;
            this.getLog().info((CharSequence)("done in " + PluginHelper.convertTime((long)time)));
        }
        if (this.testPhase) {
            this.removeTestCompileSourceRoots(this.srcDir);
        } else {
            this.removeCompileSourceRoots(this.srcDir);
        }
        if (this.testPhase) {
            this.addTestCompileSourceRoots(this.destDir);
        } else {
            this.addCompileSourceRoots(this.destDir);
        }
    }

    protected void printConfig() {
        this.getLog().info((CharSequence)("config - srcDir         " + this.srcDir));
        this.getLog().info((CharSequence)("config - destDir        " + this.destDir));
        this.getLog().info((CharSequence)("config - includes       " + this.includes));
        this.getLog().info((CharSequence)("config - filters        " + Arrays.asList(PluginHelper.splitAndTrim((String)this.filters, (String)","))));
        if (this.excludes != null) {
            this.getLog().info((CharSequence)("config - excludes       " + this.excludes));
        }
        if (!this.fileInPattern.isEmpty()) {
            this.getLog().info((CharSequence)("config - fileInPattern  " + this.fileInPattern));
        }
        if (!this.fileOutPattern.isEmpty()) {
            this.getLog().info((CharSequence)("config - fileOutPattern " + this.fileOutPattern));
        }
        if (this.overwrite) {
            this.getLog().info((CharSequence)("config - overwrite      " + this.overwrite));
        }
    }
}

