/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.widget.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.nuiton.util.FileUtil;
import org.nuiton.widget.editor.EditorInterface;

public class RSyntaxEditor
extends JPanel
implements EditorInterface,
DocumentListener {
    private static final long serialVersionUID = 5880160718377536089L;
    private static Log log = LogFactory.getLog(RSyntaxEditor.class);
    protected RSyntaxTextArea editor = new RSyntaxTextArea();
    protected boolean isModified = false;

    public RSyntaxEditor() {
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this.editor);
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
    }

    @Override
    public boolean accept(File file) {
        String ext = FileUtil.extension((File)file, (String[])new String[0]);
        boolean result = "java".equalsIgnoreCase(ext);
        result = result || "xml".equalsIgnoreCase(ext);
        result = result || "sql".equalsIgnoreCase(ext);
        result = result || "r".equalsIgnoreCase(ext);
        return result;
    }

    @Override
    public boolean open(File file) {
        block15: {
            try {
                this.editor.getDocument().removeDocumentListener(this);
                BufferedReader in = new BufferedReader(new FileReader(file));
                String text = "";
                int last = 0;
                while ((last = ((Reader)in).read()) != -1) {
                    int c = last;
                    if (13 == c) {
                        ((Reader)in).mark(1);
                        last = ((Reader)in).read();
                        if (last != -1) {
                            if ('\n' != (char)last) {
                                ((Reader)in).reset();
                            }
                            c = 10;
                        }
                    }
                    text = text + (char)c;
                }
                String ext = FileUtil.extension((File)file, (String[])new String[0]);
                if ("java".equalsIgnoreCase(ext)) {
                    this.editor.setSyntaxEditingStyle("text/java");
                } else if ("xml".equalsIgnoreCase(ext)) {
                    this.editor.setSyntaxEditingStyle("text/xml");
                } else if ("sql".equalsIgnoreCase(ext)) {
                    this.editor.setSyntaxEditingStyle("text/sql");
                } else if ("r".equalsIgnoreCase(ext)) {
                    this.editor.setSyntaxEditingStyle("text/perl");
                }
                this.editor.setText(text);
                this.editor.setCaretPosition(0);
                this.editor.getDocument().addDocumentListener(this);
                this.isModified = false;
                return true;
            }
            catch (FileNotFoundException eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Can't find file: " + file), (Throwable)eee);
                }
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block15;
                log.warn((Object)("Can't open file: " + file), (Throwable)eee);
            }
        }
        return false;
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        this.editor.getDocument().addDocumentListener(listener);
    }

    @Override
    public String getText() {
        String result = this.editor.getText();
        return result;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.editor.getDocument().removeDocumentListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveAs(File file) {
        Writer out = null;
        try {
            FileOutputStream outf = new FileOutputStream(file);
            out = new OutputStreamWriter((OutputStream)outf, "utf-8");
            this.editor.write(out);
            this.isModified = false;
            boolean bl = true;
            return bl;
        }
        catch (IOException eee) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't save file", (Throwable)eee);
            }
        }
        finally {
            block14: {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        if (!log.isWarnEnabled()) break block14;
                        log.warn((Object)"Can't save file", (Throwable)e);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void setText(String text) {
        this.editor.setText(text);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.isModified = true;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.isModified = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.isModified = true;
    }
}

