/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ValidationException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuiton.converter.ConverterUtil;
import org.nuiton.validator.xwork2.field.NuitonFieldExpressionValidator;

public class FieldExpressionWithParamsValidator
extends NuitonFieldExpressionValidator {
    protected static final Pattern EXTRA_BOOLEAN_PARAM_ENTRY_PATTERN = Pattern.compile("(\\w+)\\:(false|true)");
    protected static final Pattern EXTRA_SHORT_PARAM_ENTRY_PATTERN = Pattern.compile("(\\w+)\\:(-\\d+|\\d+)");
    protected static final Pattern EXTRA_INT_PARAM_ENTRY_PATTERN = Pattern.compile("(\\w+)\\:(-\\d+|\\d+)");
    protected static final Pattern EXTRA_LONG_PARAM_ENTRY_PATTERN = Pattern.compile("(\\w+)\\:(-\\d+|\\d+)");
    protected static final Pattern EXTRA_DOUBLE_PARAM_ENTRY_PATTERN = Pattern.compile("(\\w+)\\:(-\\d+\\.\\d+|\\d+\\.\\d+)");
    protected static final Pattern EXTRA_STRING_PARAM_ENTRY_PATTERN = Pattern.compile("(\\w+)\\:(.+)");
    protected ValueStack stack;
    protected String booleanParams;
    protected String shortParams;
    protected String intParams;
    protected String longParams;
    protected String doubleParams;
    protected String stringParams;
    protected Map<String, Boolean> booleans;
    protected Map<String, Short> shorts;
    protected Map<String, Integer> ints;
    protected Map<String, Long> longs;
    protected Map<String, Double> doubles;
    protected Map<String, String> strings;

    public String getBooleanParams() {
        return this.booleanParams;
    }

    public void setBooleanParams(String booleanParams) {
        this.booleanParams = booleanParams;
    }

    public String getDoubleParams() {
        return this.doubleParams;
    }

    public void setDoubleParams(String doubleParams) {
        this.doubleParams = doubleParams;
    }

    public String getIntParams() {
        return this.intParams;
    }

    public void setIntParams(String intParams) {
        this.intParams = intParams;
    }

    public String getLongParams() {
        return this.longParams;
    }

    public void setLongParams(String longParams) {
        this.longParams = longParams;
    }

    public String getShortParams() {
        return this.shortParams;
    }

    public void setShortParams(String shortParams) {
        this.shortParams = shortParams;
    }

    public String getStringParams() {
        return this.stringParams;
    }

    public void setStringParams(String stringParams) {
        this.stringParams = stringParams;
    }

    public Map<String, Boolean> getBooleans() {
        return this.booleans;
    }

    public Map<String, Double> getDoubles() {
        return this.doubles;
    }

    public Map<String, Integer> getInts() {
        return this.ints;
    }

    public Map<String, Long> getLongs() {
        return this.longs;
    }

    public Map<String, Short> getShorts() {
        return this.shorts;
    }

    public Map<String, String> getStrings() {
        return this.strings;
    }

    public String getValidatorType() {
        return "fieldexpressionwithparams";
    }

    public void setValueStack(ValueStack stack) {
        super.setValueStack(stack);
        this.stack = stack;
    }

    @Override
    public void validate(Object object) throws ValidationException {
        super.validate(object);
    }

    @Override
    public void validateWhenNotSkip(Object object) throws ValidationException {
        this.booleans = this.initParams(Boolean.class, this.booleanParams, EXTRA_BOOLEAN_PARAM_ENTRY_PATTERN);
        this.shorts = this.initParams(Short.class, this.shortParams, EXTRA_SHORT_PARAM_ENTRY_PATTERN);
        this.ints = this.initParams(Integer.class, this.intParams, EXTRA_INT_PARAM_ENTRY_PATTERN);
        this.longs = this.initParams(Long.class, this.longParams, EXTRA_LONG_PARAM_ENTRY_PATTERN);
        this.doubles = this.initParams(Double.class, this.doubleParams, EXTRA_DOUBLE_PARAM_ENTRY_PATTERN);
        this.strings = this.initParams(String.class, this.stringParams, EXTRA_STRING_PARAM_ENTRY_PATTERN);
        boolean pop = false;
        if (!this.stack.getRoot().contains((Object)this)) {
            this.stack.push((Object)this);
            pop = true;
        }
        try {
            super.validateWhenNotSkip(object);
        }
        finally {
            if (pop) {
                this.stack.pop();
            }
        }
    }

    protected <T> Map<String, T> initParams(Class<T> klass, String extraParams, Pattern pattern) throws ValidationException {
        if (extraParams == null || extraParams.isEmpty()) {
            return null;
        }
        StringTokenizer stk = new StringTokenizer(extraParams, "|");
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        while (stk.hasMoreTokens()) {
            String entry = stk.nextToken();
            Matcher matcher = pattern.matcher(entry);
            if (!matcher.matches()) {
                throw new ValidationException("could not parse for extra params " + extraParams + " for type " + klass.getName());
            }
            String paramName = matcher.group(1);
            String paramValueStr = matcher.group(2);
            Object paramValue = ConverterUtil.convert(klass, (Object)paramValueStr);
            if (this.log.isDebugEnabled()) {
                this.log.debug("detected extra param : <type:" + klass + ", name:" + paramName + ", value:" + paramValue + ">", new String[0]);
            }
            result.put(paramName, paramValue);
        }
        return result;
    }
}

