/*
 * #%L
 * Nuiton Utils :: Nuiton Validator
 * 
 * $Id: BeanValidatorUtil.java 2068 2011-01-27 08:10:53Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.5/nuiton-validator/src/main/java/org/nuiton/validator/bean/BeanValidatorUtil.java $
 * %%
 * Copyright (C) 2011 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.validator.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.NuitonValidatorScope;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;

/**
 * The helper class for bean validation module.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0
 */
public class BeanValidatorUtil {

    /** Logger */
    static private final Log log = LogFactory.getLog(BeanValidatorUtil.class);

    protected BeanValidatorUtil() {
        // no instance
    }

    /**
     * Convert a value to a given type and then if was succesffull try to set it
     * in the bean manage by the validator.
     *
     * @param validator  validator to be involved
     * @param fieldName  the name of the bean property
     * @param value      the actual value to convert
     * @param valueClass the type of the conversion
     */
    public static void convert(BeanValidator<?> validator,
                               String fieldName,
                               String value,
                               Class<?> valueClass) {

        Object result = validator.convert(fieldName, value, valueClass);
        if (result != null) {
            try {
                BeanInfo info =
                        Introspector.getBeanInfo(validator.getBean().getClass());

                for (PropertyDescriptor descriptor :
                        info.getPropertyDescriptors()) {
                    if (fieldName.equals(descriptor.getName()) &&
                        descriptor.getWriteMethod() != null) {

                        descriptor.getWriteMethod().invoke(
                                validator.getBean(),
                                result
                        );
                        break;
                    }
                }
            } catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("could not obtain beanInfo for " +
                              valueClass.getClass() + ", reason : " +
                              e.getMessage(), e);
                }
            }
        } else {
            //fixme : conversion failed, we should be able  to notify ui
            // that values has changed ?
            // otherwise, bean value has not changed,...
        }
    }

    public static EnumSet<NuitonValidatorScope> getScopes(
            List<BeanValidatorMessage<?>> messages) {
        EnumSet<NuitonValidatorScope> result =
                EnumSet.noneOf(NuitonValidatorScope.class);
        for (BeanValidatorMessage<?> m : messages) {
            result.add(m.getScope());
        }
        return result;
    }

    public static EnumMap<NuitonValidatorScope, Integer> getScopesCount(
            List<BeanValidatorMessage<?>> messages) {
        EnumMap<NuitonValidatorScope, Integer> result =
                new EnumMap<NuitonValidatorScope, Integer>(NuitonValidatorScope.class);
        for (NuitonValidatorScope s : NuitonValidatorScope.values()) {
            result.put(s, 0);
        }
        for (BeanValidatorMessage<?> m : messages) {

            NuitonValidatorScope scope = m.getScope();

            result.put(scope, result.get(scope) + 1);
        }

        for (NuitonValidatorScope s : NuitonValidatorScope.values()) {
            if (result.get(s) == 0) {
                result.remove(s);
            }
        }
        return result;
    }

}
