/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    public static final String DEFAULT_PATTERN = "dd/MM/yyyy";
    public static final String MONTH_PATTERN = "MM/yyyy";

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(date);
    }

    public static String formatDate(Date date, String pattern, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, locale);
        return simpleDateFormat.format(date);
    }

    public static Date parseDate(String date, String pattern) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        Date result = simpleDateFormat.parse(date);
        return result;
    }

    public static Date createDate(int s, int m, int h, int dd, int mm, int yy) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(0L);
        calendar.set(1, yy);
        calendar.set(2, mm - 1);
        calendar.set(5, dd);
        calendar.set(11, h);
        calendar.set(12, m);
        calendar.set(13, s);
        return calendar.getTime();
    }

    public static Date createDate(int dd, int mm, int yy) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, yy);
        calendar.set(2, mm - 1);
        calendar.set(5, dd);
        return DateUtil.setMinTimeOfDay(calendar.getTime());
    }

    public static Date createDateAfterToday(int ddStep, int mmStep, int yyStep) {
        Calendar calendar = DateUtil.getDefaultCalendar(new Date());
        calendar.add(5, ddStep);
        calendar.add(2, mmStep);
        calendar.add(1, yyStep);
        return calendar.getTime();
    }

    public static Date setLastDayOfMonth(Date date) {
        Calendar calendar = DateUtil.getDefaultCalendar(date);
        int maximum = calendar.getActualMaximum(5);
        calendar.set(5, maximum);
        Date lastDay = calendar.getTime();
        return lastDay;
    }

    public static Date setFirstDayOfMonth(Date date) {
        Calendar calendar = DateUtil.getDefaultCalendar(date);
        calendar.set(5, 1);
        Date firstDay = calendar.getTime();
        return firstDay;
    }

    public static Date setLastDayOfYear(Date date) {
        Calendar calendar = DateUtil.getDefaultCalendar(date);
        int maximum = calendar.getActualMaximum(6);
        calendar.set(6, maximum);
        Date lastDay = calendar.getTime();
        return lastDay;
    }

    public static Date setFirstDayOfYear(Date date) {
        Calendar calendar = DateUtil.getDefaultCalendar(date);
        calendar.set(6, 1);
        Date firstDay = calendar.getTime();
        return firstDay;
    }

    public static Date setMinTimeOfDay(Date date) {
        Calendar calendar = DateUtil.getDefaultCalendar(date);
        calendar.set(9, 0);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date setMaxTimeOfDay(Date date) {
        Calendar calendar = DateUtil.getDefaultCalendar(date);
        calendar.set(9, 1);
        calendar.set(10, 11);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static boolean between(Date myDate, Date beforeDate, Date afterDate) {
        if (myDate == null) {
            return false;
        }
        boolean result = true;
        result &= myDate.after(beforeDate) || myDate.compareTo(beforeDate) == 0;
        return result &= afterDate == null || myDate.before(afterDate) || myDate.compareTo(afterDate) == 0;
    }

    public static boolean currentPeriod(Date beforeDate, Date afterDate) {
        return DateUtil.between(new Date(), beforeDate, afterDate);
    }

    public static int getMonth(Date date) {
        Calendar calendar = DateUtil.getDefaultCalendar(date);
        return calendar.get(2);
    }

    public static int getDifferenceInSeconds(Date beginDate, Date endDate) {
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        return (int)Math.ceil((end - begin) / 1000L);
    }

    public static int getDifferenceInMinutes(Date beginDate, Date endDate) {
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        return (int)Math.ceil((end - begin) / 60000L);
    }

    public static int getDifferenceInHours(Date beginDate, Date endDate) {
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        return (int)Math.ceil((end - begin) / 3600000L);
    }

    public static int getDifferenceInDays(Date beginDate, Date endDate) {
        LocalDate end = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate begin = beginDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return (int)begin.until(end, ChronoUnit.DAYS);
    }

    public static int getDifferenceInMonths(Date beginDate, Date endDate) {
        int count = 0;
        Calendar fromCalendar = DateUtil.getDefaultCalendar(beginDate);
        Calendar thruCalendar = DateUtil.getDefaultCalendar(endDate);
        while (fromCalendar.before(thruCalendar)) {
            fromCalendar.add(2, 1);
            ++count;
        }
        return count;
    }

    public static int getAge(Date birthDate) {
        int count = 0;
        Calendar fromCalendar = DateUtil.getDefaultCalendar(birthDate);
        Calendar thruCalendar = DateUtil.getDefaultCalendar(new Date());
        fromCalendar.add(1, 1);
        while (fromCalendar.before(thruCalendar)) {
            ++count;
            fromCalendar.add(1, 1);
        }
        return count;
    }

    public static String getMonthLibelle(int monthNumber, Locale locale) {
        return new DateFormatSymbols(locale).getMonths()[monthNumber - 1];
    }

    public static String getMonthLibelle(int monthNumber) {
        return DateUtil.getMonthLibelle(monthNumber, Locale.getDefault());
    }

    public static Date getYesterday(Date date) {
        Calendar cal = DateUtil.getDefaultCalendar(date);
        if (cal.get(2) == 0 && cal.get(5) == 1) {
            cal.roll(1, false);
        }
        if (cal.get(5) == 1) {
            cal.roll(2, false);
        }
        cal.roll(5, false);
        return cal.getTime();
    }

    public static Calendar getDefaultCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Date truncateToDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        date = calendar.getTime();
        return date;
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 999);
        calendar.set(13, 59);
        calendar.set(12, 59);
        calendar.set(11, 23);
        date = calendar.getTime();
        return date;
    }

    public static Date getDateAndTime(Date day, Date time, boolean useSecond, boolean useMiliSecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int h = calendar.get(11);
        int m = calendar.get(12);
        int s = useSecond ? calendar.get(13) : 0;
        int ms = useMiliSecond ? calendar.get(14) : 0;
        calendar.setTime(day);
        calendar.set(11, h);
        calendar.set(12, m);
        calendar.set(13, s);
        calendar.set(14, ms);
        return calendar.getTime();
    }

    public static Date getTime(Date dayTime, boolean useSecond, boolean useMiliSecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dayTime);
        int h = calendar.get(11);
        int m = calendar.get(12);
        int s = calendar.get(13);
        int ms = calendar.get(14);
        calendar.setTimeInMillis(0L);
        calendar.set(11, h);
        calendar.set(12, m);
        if (useSecond) {
            calendar.set(13, s);
        }
        if (useMiliSecond) {
            calendar.set(14, ms);
        }
        return calendar.getTime();
    }
}

