/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: FormatConverter.java 2650 2014-07-16 07:40:47Z tchemit $
 * $HeadURL: https://svn.nuiton.org/nuiton-utils/tags/nuiton-utils-3.0-rc-8/src/main/java/org/nuiton/util/converter/FormatConverter.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/* *
 * FormatConverter.java
 *
 * Created: 14 septembre 2005 00:55:19 CEST
 *
 * @author Benjamin POUSSIN <poussin@codelutin.com>
 * @version $Revision: 2650 $
 *
 * Last update: $Date: 2014-07-16 09:40:47 +0200 (Wed, 16 Jul 2014) $
 * by : */

package org.nuiton.util.converter;

import org.nuiton.util.converter.FormatMap.Format;

/**
 * Un converter est un objet qui permet de passé d'une representation d'un
 * objet vers une autre representation. Le mininum que converter doit savoir
 * faire, est de converter une representation Java vers le format qu'il
 * gère et inversement. Pour des raisons d'optimisation, il est possible
 * qu'un converter sache passé d'un autre type que java vers sa representation
 * pour eviter une conversion supplémentaire qui pourrait-etre couteuse.
 *
 * @param <A> le type de l'objet a convertir
 * @deprecated since 3.0, will not pe replaced by anything (see https://forge.nuiton.org/issues/3326); will be removed later
 */
@Deprecated
public interface FormatConverter<A> { // FormatConverter

    Format FORMAT_JAVA = new Format("Format Java");

    /**
     * Convertie une valeur vers la representation FORMAT géré par cette classe
     *
     * @param factory la factory utilisable pour rechercher d'autre converter
     *                si la representation Java n'est pas presente dans values et que l'on
     *                en a besoin
     * @param format  le format souhaité en sortie
     * @param values  une map contenant les différentes representation de la
     *                meme valeur. Les cles de la map sont les valeurs retournés par la
     *                methode getFormat().
     * @param args    des arguments qui peuvent-être utile pour la conversion.
     *                par exemple si dans une application on a construit son propre
     *                converter et que pour la conversion, on a besoin d'un Context applicatif
     *                il peut-etre passé dans les args. Si le converter a besoin d'autre
     *                converter les memes args lui seront passé.
     * @return l'objet dans la representation demandés par type
     * @throws IllegalArgumentException si auncun moyen n'est trouve pour
     *                                  convertir une des valeurs de values dans le format géré par cette classe.
     *                                  Ou s'il manque dans les args des objets utils pour la conversion.
     */
    A convert(FormatConverterFactory factory,
              Format format, FormatMap values, Object... args);

    /**
     * Convertie une valeur vers le Java
     *
     * @param factory la factory utilisable pour rechercher d'autre converter
     *                si la representation Java n'est pas presente dans values et que l'on
     *                en a besoin
     * @param format  le format à utiliser comme valeur d'entré
     * @param values  une map contenant les différentes representation de la
     *                meme valeur. La valeur interessante dans la map pour cette methode
     *                est celle retournée par values.get(getFormat()) si cet appel, ne
     *                retourne pas quelque chose de valid, la methode doit lever une exception
     * @param args    des arguments qui peuvent-être utile pour la conversion.
     *                par exemple si dans une application on a construit son propre
     *                converter et que pour la conversion, on a besoin d'un Context applicatif
     *                il peut-etre passé dans les args. Si le converter a besoin d'autre
     *                converter les memes args lui seront passé.
     * @return la valeur java
     * @throws IllegalArgumentException si le format géré par cette classe n'est
     *                                  pas trouvé dans les values. Ou s'il manque dans les args des objets utils
     *                                  pour la conversion.
     */
    Object unconvert(FormatConverterFactory factory,
                     Format format, FormatMap values, Object... args);

} // FormatConverter

