/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.VersionUtil;

public class ApplicationUpdater {
    private static Log log = LogFactory.getLog(ApplicationUpdater.class);
    private static final String SEPARATOR_KEY = ".";
    public static final String HTTP_PROXY = "http_proxy";
    public static final String URL_KEY = "url";
    public static final String AUTHENTICATION_KEY = "auth";
    public static final String VERSION_KEY = "version";
    public static final String VERSION_FILE = "version.appup";
    protected ApplicationConfig config;

    public ApplicationUpdater() {
        this(null);
    }

    public ApplicationUpdater(ApplicationConfig config) {
        if (config == null) {
            try {
                config = new ApplicationConfig(ApplicationUpdater.class.getSimpleName() + ".properties");
                config.parse(new String[0]);
                config = config.getSubConfig(ApplicationUpdater.class.getSimpleName() + SEPARATOR_KEY);
            }
            catch (ArgumentsParserException eee) {
                throw new RuntimeException(eee);
            }
        }
        this.config = config;
    }

    public void update(String vfsPropertiesURL, File currentDir, File destDir, boolean async, ApplicationUpdaterCallback callback) {
        Updater up = new Updater(this.config, vfsPropertiesURL, currentDir, destDir, callback);
        if (async) {
            Thread thread = new Thread((Runnable)up, ApplicationUpdater.class.getSimpleName());
            thread.start();
        } else {
            up.run();
        }
    }

    public static class Updater
    implements Runnable {
        protected ApplicationConfig config;
        protected String vfsPropertiesUrl;
        protected File currentDir;
        protected File destDir;
        protected ApplicationUpdaterCallback callback;

        public Updater(ApplicationConfig config, String vfsPropertiesUrl, File currentDir, File destDir, ApplicationUpdaterCallback callback) {
            this.config = config;
            this.vfsPropertiesUrl = vfsPropertiesUrl;
            this.currentDir = currentDir;
            this.destDir = destDir;
            this.callback = callback;
        }

        @Override
        public void run() {
            block11: {
                try {
                    FileSystemOptions vfsConfig = this.getVFSConfig(this.config);
                    ApplicationConfig releaseConfig = this.getUpdaterConfig(vfsConfig, this.vfsPropertiesUrl);
                    List<String> appNames = this.getApplicationName(releaseConfig);
                    Map<String, String> appVersions = this.getCurrentVersion(appNames, this.currentDir);
                    log.debug((Object)("application current version: " + appVersions));
                    Map<String, ApplicationInfo> appToUpdate = new HashMap<String, ApplicationInfo>();
                    for (String app : appNames) {
                        String currentVersion = appVersions.get(app);
                        String newVersion = releaseConfig.getOption(app + ApplicationUpdater.SEPARATOR_KEY + ApplicationUpdater.VERSION_KEY);
                        boolean greater = VersionUtil.greaterThan(newVersion, currentVersion);
                        log.debug((Object)String.format("for %s Current(%s) < newVersion(%s) ? %s", app, currentVersion, newVersion, greater));
                        if (!greater) continue;
                        String urlString = releaseConfig.getOption(app + ApplicationUpdater.SEPARATOR_KEY + ApplicationUpdater.URL_KEY);
                        boolean needAuthentication = releaseConfig.getOptionAsBoolean(app + ApplicationUpdater.SEPARATOR_KEY + ApplicationUpdater.AUTHENTICATION_KEY);
                        appToUpdate.put(app, new ApplicationInfo(app, currentVersion, newVersion, urlString, this.destDir, needAuthentication));
                    }
                    if (this.callback != null) {
                        appToUpdate = this.callback.updateToDo(appToUpdate);
                    }
                    HashMap<String, Exception> appUpdateError = new HashMap<String, Exception>();
                    for (Map.Entry<String, ApplicationInfo> appInfo : appToUpdate.entrySet()) {
                        String app = appInfo.getKey();
                        ApplicationInfo info = appInfo.getValue();
                        try {
                            this.doUpdate(vfsConfig, appInfo.getValue());
                        }
                        catch (Exception eee) {
                            appUpdateError.put(app, eee);
                            try {
                                File dest = new File(info.destDir, info.name);
                                if (dest.exists()) {
                                    log.debug((Object)String.format("Cleaning destination directory due to error '%s'", dest));
                                    FileUtils.deleteDirectory((File)dest);
                                }
                            }
                            catch (Exception doNothing) {
                                log.debug((Object)"Can't clean directory", (Throwable)doNothing);
                            }
                            log.warn((Object)String.format("Can't update application '%s' with url '%s'", app, info.url));
                            log.debug((Object)"Application update aborted because: ", (Throwable)eee);
                        }
                    }
                    if (this.callback != null) {
                        this.callback.updateDone(appToUpdate, appUpdateError);
                    }
                }
                catch (Exception eee) {
                    log.warn((Object)"Can't update");
                    log.info((Object)"Application update aborted because: ", (Throwable)eee);
                    if (this.callback == null) break block11;
                    this.callback.aborted(this.vfsPropertiesUrl, eee);
                }
            }
        }

        protected void doUpdate(FileSystemOptions vfsConfig, ApplicationInfo info) throws Exception {
            if (info.destDir != null) {
                File dest = new File(info.destDir, info.name);
                String url = this.toVfsURL(info.url);
                if (info.needAuthentication) {
                    url = StringUtils.replaceOnce((String)url, (String)"://", (String)String.format("://%s:%s@", info.login, new String(info.password)));
                }
                this.deepCopy(vfsConfig, url, dest.getAbsolutePath());
                File versionFile = new File(dest, ApplicationUpdater.VERSION_FILE);
                FileUtils.writeStringToFile((File)versionFile, (String)info.newVersion);
                log.info((Object)String.format("Application '%s' is uptodate with version '%s' in '%s'", info.name, info.newVersion, info.destDir));
            } else {
                log.info((Object)String.format("Update for '%s' aborted because destination dir is set to null", info.name));
            }
        }

        protected void deepCopy(FileSystemOptions vfsConfig, String srcPath, String targetPath) throws FileSystemException {
            FileSystemManager fsManager = VFS.getManager();
            FileObject archive = fsManager.resolveFile(srcPath, vfsConfig);
            FileObject[] children = archive.getChildren();
            if (children.length != 1) {
                throw new RuntimeException("must have only one root directory");
            }
            FileObject child = children[0];
            FileObject target = fsManager.resolveFile(this.toVfsURL(targetPath), vfsConfig);
            target.delete((FileSelector)new AllFileSelector());
            target.copyFrom(child, (FileSelector)new AllFileSelector());
        }

        protected String toVfsURL(String path) {
            String result = path;
            Pattern p = Pattern.compile("(.*?file:)([^/][^!]*)(.*)");
            Matcher m = p.matcher(path);
            if (m.matches()) {
                String filepath = m.group(2);
                File f = new File(filepath);
                result = path.replaceAll("(.*?file:)([^/][^!]*)(.*)", "$1" + f.getAbsolutePath() + "$3");
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ApplicationConfig getUpdaterConfig(FileSystemOptions vfsConfig, String vfsPropertiesUrl) throws Exception {
            String osName = StringUtils.lowerCase((String)this.config.getOsName());
            String osArch = StringUtils.lowerCase((String)this.config.getOsArch());
            osName = StringUtils.substringBefore((String)osName, (String)" ");
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Try to load properties from '%s'", vfsPropertiesUrl));
            }
            Properties prop = new Properties();
            FileSystemManager fsManager = VFS.getManager();
            FileObject properties = fsManager.resolveFile(this.toVfsURL(vfsPropertiesUrl), vfsConfig);
            try {
                BufferedInputStream in = new BufferedInputStream(properties.getContent().getInputStream());
                prop.load(in);
            }
            finally {
                try {
                    properties.close();
                }
                catch (Exception doNothing) {
                    log.debug((Object)"Can't close vfs file", (Throwable)doNothing);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Properties loaded from '%s'\n%s", vfsPropertiesUrl, prop));
            }
            ApplicationConfig result = new ApplicationConfig(prop);
            result = result.getSubConfig(ApplicationUpdater.class.getSimpleName() + ApplicationUpdater.SEPARATOR_KEY);
            result = result.getSubConfig(osName + ApplicationUpdater.SEPARATOR_KEY);
            result = result.getSubConfig(osArch + ApplicationUpdater.SEPARATOR_KEY);
            return result;
        }

        protected FileSystemOptions getVFSConfig(ApplicationConfig config) {
            FileSystemOptions result = new FileSystemOptions();
            String proxyHost = config.getOption(ApplicationUpdater.HTTP_PROXY);
            try {
                proxyHost = StringUtils.substringAfter((String)proxyHost, (String)"://");
                if (StringUtils.isNotBlank((CharSequence)proxyHost)) {
                    String hostname = StringUtils.substringBefore((String)proxyHost, (String)":");
                    String port = StringUtils.substringAfter((String)proxyHost, (String)":");
                    if (StringUtils.isNumeric((CharSequence)port)) {
                        int portNumber = Integer.parseInt(port);
                        HttpFileSystemConfigBuilder.getInstance().setProxyHost(result, hostname);
                        HttpFileSystemConfigBuilder.getInstance().setProxyPort(result, portNumber);
                    } else {
                        log.warn((Object)String.format("Invalide proxy port number '%s', not used proxy", port));
                    }
                }
            }
            catch (Exception eee) {
                log.warn((Object)String.format("Can't use proxy '%s'", proxyHost), (Throwable)eee);
            }
            return result;
        }

        protected Map<String, String> getCurrentVersion(List<String> apps, File dir) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (String app : apps) {
                File f = new File(dir, app + File.separator + ApplicationUpdater.VERSION_FILE);
                String version = "0";
                try {
                    version = FileUtils.readFileToString((File)f);
                }
                catch (IOException ex) {
                    log.warn((Object)String.format("Can't find file version '%s' for application '%s', this file should be '%s'", ApplicationUpdater.VERSION_FILE, app, f));
                }
                version = StringUtils.trim((String)version);
                result.put(app, version);
            }
            return result;
        }

        protected List<String> getApplicationName(ApplicationConfig config) {
            Pattern p = Pattern.compile("([^.]+)\\.version");
            LinkedList<String> result = new LinkedList<String>();
            for (String v : config.getFlatOptions().stringPropertyNames()) {
                Matcher match = p.matcher(v);
                if (match.matches()) {
                    result.add(match.group(1));
                    continue;
                }
                if (!StringUtils.endsWith((CharSequence)v, (CharSequence)".version")) continue;
                log.debug((Object)String.format("value is not valid application version '%s'", v));
            }
            return result;
        }
    }

    public static class ApplicationInfo {
        public String name;
        public String oldVersion;
        public String newVersion;
        public String url;
        public boolean needAuthentication;
        public String login;
        public char[] password;
        public File destDir;

        public ApplicationInfo(String name, String oldVersion, String newVersion, String url, File destDir, boolean needAuthentication) {
            this.name = name;
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
            this.url = url;
            this.needAuthentication = needAuthentication;
            this.destDir = destDir;
        }

        public void setAuthentication(String login, char[] password) {
            this.login = login;
            this.password = password;
        }

        public String toString() {
            String result = String.format("App: %s, oldVersion: %s, newVersion: %s, url: %s, destDir:%s", this.name, this.oldVersion, this.newVersion, this.url, this.destDir);
            return result;
        }
    }

    public static interface ApplicationUpdaterCallback {
        public Map<String, ApplicationInfo> updateToDo(Map<String, ApplicationInfo> var1);

        public void updateDone(Map<String, ApplicationInfo> var1, Map<String, Exception> var2);

        public void aborted(String var1, Exception var2);
    }
}

