/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: RecursiveProperties.java 1948 2010-11-17 21:31:00Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.1/nuiton-utils/src/main/java/org/nuiton/util/RecursiveProperties.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/* *
 * RecursiveProperties.java
 *
 * Created: 28 juil. 2005
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 * Copyright Code Lutin
 * @version $Revision: 1948 $
 *
 * Mise a jour: $Date: 2010-11-17 22:31:00 +0100 (mer, 17 nov 2010) $
 * par : */

package org.nuiton.util;

import java.util.Properties;

/**
 * Surcharge java.util.Properties de manière à aller chercher dans les
 * properties la valeur de la propriété si celle ci est encadrée par "${...}".
 * <p/>
 * Exemple :
 * myFirstName=Arnaud
 * myName=Thimel
 * org.nuiton.topia.userInfo.fullName=${fullName}
 * fullName=${myFirstName} ${myName}
 * namePhrase=My name is ${myName}.
 * instruction=Placez votre texte comme ceci : ${monTexte}
 * <p/>
 * Dans ce cas,
 * getProperty("org.nuiton.topia.userInfo.fullName") renverra "Arnaud Thimel"
 * getProperty("namePhrase") renverra "My name is Thimel."
 * getProperty("instruction") renverra "Placez votre texte comme ceci : ${monTexte}"
 *
 * @author thimel
 */
public class RecursiveProperties extends Properties {

    private static final long serialVersionUID = -5012939272780929116L;

    public RecursiveProperties() {
    }

    public RecursiveProperties(Properties defaults) {
        super(defaults);
    }

    @Override
    public String getProperty(String key) {
        String result = super.getProperty(key);
        if (result == null) {
            return null;
        }
        //Ex : result="My name is ${myName}."
        int pos = result.indexOf("${", 0);
        //Ex : pos=11
        while (pos != -1) {
            int posEnd = result.indexOf("}", pos + 1);
            //Ex : posEnd=19
            if (posEnd != -1) {
                String value = getProperty(result.substring(pos + 2, posEnd));
                // Ex : getProperty("myName");
                if (value != null) {
                    // Ex : value="Thimel"
                    result = result.substring(0, pos) + value + result.substring(posEnd + 1);
                    // Ex : result="My name is " + "Thimel" + "."
                    pos = result.indexOf("${", pos + value.length());
                    // Ex : pos=-1
                } else {
                    // Ex : value=null
                    pos = result.indexOf("${", posEnd + 1);
                    // Ex : pos=-1
                }
                // Ex : pos=-1
            }
        }
        return result;
    }

} //RecursiveProperties
