/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: TransformedList.java 1948 2010-11-17 21:31:00Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.0/nuiton-utils/src/main/java/org/nuiton/util/TransformedList.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/* *
 * TransformedList.java
 *
 * Created: 2 août 2005 02:12:42 CEST
 *
 * @author Benjamin POUSSIN <poussin@codelutin.com>
 * @version $Revision: 1948 $
 *
 * Last update: $Date: 2010-11-17 22:31:00 +0100 (Wed, 17 Nov 2010) $
 * by : */
package org.nuiton.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * TODO Wthat is it for ?
 * @param <E>
 */
public class TransformedList<E> extends AbstractList<E> implements Serializable { // TransformedList

    private static final long serialVersionUID = 2354881761407900789L;
    protected Transformer<E, ? super Object> transformer;
    protected List<Object> inner;

    public TransformedList(Transformer<E, ? super Object> transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("Transformer must not be null");
        }

        this.transformer = transformer;
        inner = new ArrayList<Object>();
    }

    public TransformedList(Transformer<E, ? super Object> transformer,
                           Collection<? extends E> c) {
        this(transformer);
        addAll(c);
    }

    @Override
    public int size() {
        return inner.size();
    }

    @Override
    public E get(int index) {
        Object f = inner.get(index);
        E result = transformer.untransform(f);
        return result;
    }

    @Override
    public E set(int index, E element) {
        Object f = transformer.transform(element);
        f = inner.set(index, f);
        E result = transformer.untransform(f);
        return result;
    }

    @Override
    public void add(int index, E element) {
        Object f = transformer.transform(element);
        inner.add(index, f);
    }

    @Override
    public E remove(int index) {
        Object f = inner.remove(index);
        E result = transformer.untransform(f);
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(transformer);
        out.writeObject(inner);
    }

    @SuppressWarnings("unchecked")
    private void readObject(ObjectInputStream in) throws IOException,
                                                         ClassNotFoundException {
        in.defaultReadObject();
        transformer = (Transformer<E, Object>) in.readObject();
        inner = (List<Object>) in.readObject();
    }
} // TransformedList

