/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: ArrayUtil.java 1830 2010-04-15 14:29:20Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-1.5/src/main/java/org/nuiton/util/ArrayUtil.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */


/* *
 * ArrayUtil.java
 *
 * Created: 31 oct. 2004
 *
 * @author Benjamin Poussin <poussin@codelutin.com>
 * @version $Revision: 1830 $
 *
 * Mise a jour: $Date: 2010-04-15 16:29:20 +0200 (jeu., 15 avril 2010) $
 * par : */

package org.nuiton.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ArrayUtil { // ArrayUtil

    /**
     * Permet de convertir un tableau en une liste, le type primitif
     * est encapsulé dans un objet.
     *
     * @param a le tableau a convertir
     * @return la liste
     * @deprecated avec l'auto-boxing en java 5 et plus ?
     */
    static public List<Double> asList(double[] a) {
        ArrayList<Double> result = new ArrayList<Double>(a.length);
        for (double anA : a) {
            result.add(anA);
        }
        return result;
    }

    static public <T> List<T> asList(T[] a) {
        return Arrays.asList(a);
    }

    /**
     * Permet de convertir un tableau en une liste, le type primitif
     * est encapsulé dans un objet.
     *
     * @param a le tableau a convertir
     * @return la liste
     * @deprecated avec l'auto-boxing en java 5 et plus ?
     */
    static public List<Integer> asList(int[] a) {
        ArrayList<Integer> result = new ArrayList<Integer>(a.length);
        for (int anA : a) {
            result.add(anA);
        }
        return result;
    }

    public static int[] asIntArray(String[] a) {
        int[] result = new int[a.length];
        for (int i = 0; i < a.length; i++) {
            result[i] = StringUtil.toInt(a[i]);
        }
        return result;
    }


    /**
     * Fait la somme des 2 tableaux et retourne un nouveau tableau, les
     * 2 tableaux passés en argument ne sont pas modifiés. Les deux tableaux
     * doivent être non null et avoir la même taille.
     *
     * @param a le premier tableau
     * @param b le second tableau
     * @return le tableau des sommes
     */
    static public int[] sum(int[] a, int[] b) {
        if (a == null || b == null || a.length != b.length) {
            throw new IllegalArgumentException("Au moins des tableaux est null ou les tableaux ne font pas la même taille");
        }
        int[] result = new int[a.length];
        for (int i = 0; i < a.length; i++) {
            result[i] = a[i] + b[i];
        }
        return result;
    }

    static public int[] concat(int[]... tabs) {
        int length = 0;
        for (int[] tab : tabs) {
            if (tab != null) {
                length += tab.length;
            }
        }
        int[] result = new int[length];
        length = 0;
        for (int[] tab : tabs) {
            if (tab != null) {
                System.arraycopy(tab, 0, result, length, tab.length);
                length += tab.length;
            }
        }
        return result;
    }

    /**
     * Retourne un nouveau tableau qui est la concatenation des deux autres.
     * Essai de garder pour le tableau resultat le type des tableaux en entré
     * si possible. [Double], [Number] -> [Number]; [Double], [Long] -> [Object]
     *
     * @param tabs les tableaux
     * @return le nouveau tableau ou null, si les deux tableaux sont null
     *         todo essayer de retourner le meilleur type de tableau possible
     *         [Double], [Long] -> [Number]
     */
    static public Object[] concat(Object[]... tabs) {
        Object[] result = null;
        Class<?> clazz = null;
        int length = 0;
        for (Object[] tab : tabs) {
            if (tab != null) {
                length += tab.length;
                Class<?> tmp = tab.getClass().getComponentType();
                if (clazz == null) {
                    clazz = tmp;
                } else if (tmp.isAssignableFrom(clazz)) {
                    clazz = tmp;
                } else if (clazz.isAssignableFrom(tmp)) {
                    // do nothing, because clazz can't be better
                } else {
                    clazz = Object.class;
                }
            }
        }

        if (clazz != null) {
            result = (Object[]) Array.newInstance(clazz, length);
            length = 0;
            for (Object[] tab : tabs) {
                if (tab != null) {
                    System.arraycopy(tab, 0, result, length, tab.length);
                    length += tab.length;
                }
            }
        }
        return result;
    }

    /**
     * Ajoute a un tableau un ensemble d'element. Le type du tableau retourné
     * est le meilleur possible.
     *
     * @param tab   les valeurs initiales du tableau
     * @param elems les elemements a ajouter
     * @return un nouveau tableau contenant a la fin les elements souhaites
     */
    @SuppressWarnings("unchecked")
    static public <E, F extends E> E[] concatElems(E[] tab, F... elems) {
        E[] result;
        result = (E[]) concat(tab, elems);
        return result;
    }

    /**
     * Recherche dans le table le 1er element qui correspond a la classe
     * passée en argument.
     *
     * @param tab   le tableau dans lequel il faut chercher
     * @param clazz la classe de l'objet souhaité
     * @return un objet de la classe demandé, ou null si aucun ne correspond
     */
    static public <A> A search(Object[] tab, Class<A> clazz) {
        A result = null;
        for (Object o : tab) {
            if (clazz.isInstance(o)) {
                result = clazz.cast(o);
            }
        }
        return result;
    }

    @SuppressWarnings({"unchecked"})
    static public <T> T[] toArray(Collection list, Class<T> clazz) {
        T[] result = (T[]) Array.newInstance(clazz, list == null ? 0 : list.size());
        int i = 0;
        for (Object o : list) {
            result[i++] = (T) o;
        }
        return result;
    }
} // ArrayUtil

