/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ClassLoaderUtil;
import org.nuiton.util.HashList;
import org.nuiton.util.ResourceException;
import org.nuiton.util.ResourceNotFoundException;
import org.nuiton.util.StringUtil;

public class Resource {
    private static final Log log = LogFactory.getLog(Resource.class);

    protected Resource() {
    }

    public static void addDefaultClassLoader(URL url) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Resource.addClassLoader(classLoader, url);
    }

    public static void addClassLoader(ClassLoader classLoader, URL url) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, url);
        }
        catch (Exception eee) {
            throw new RuntimeException(I18n._((String)"nuitonutil.error.add.url.in.classloader", (Object[])new Object[]{classLoader, eee}));
        }
    }

    public static URL getURL(String name) {
        URL url = Resource.getURLOrNull(name);
        if (url != null) {
            return url;
        }
        throw new ResourceNotFoundException(I18n._((String)"nuitonutil.error.resource.not.found", (Object[])new Object[]{name}));
    }

    public static URL getURLOrNull(String name) {
        URL url;
        File file = new File(name);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException eee) {
                log.warn((Object)I18n._((String)"nuitonutil.error.convert.file.to.url", (Object[])new Object[]{file, eee.getMessage()}));
            }
        }
        if (name.length() > 1 && name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((url = ClassLoader.getSystemClassLoader().getResource(name)) != null) {
            return url;
        }
        ClassLoader cl = Resource.class.getClassLoader();
        url = cl.getResource(name);
        return url;
    }

    public static ImageIcon getIcon(String name) {
        try {
            return new ImageIcon(Resource.getURL(name));
        }
        catch (Exception eee) {
            log.warn((Object)("Can't find icon: " + name), (Throwable)eee);
            return null;
        }
    }

    @Deprecated
    public static Properties getConfigProperties(String filename) throws IOException {
        Properties result = Resource.getConfigProperties(filename, null);
        return result;
    }

    @Deprecated
    public static Properties getConfigProperties(String filename, Properties parent) throws IOException {
        File config;
        File etcConfig;
        Properties result = parent != null ? new Properties(parent) : new Properties();
        URL inClasspath = ClassLoader.getSystemClassLoader().getResource(filename);
        if (inClasspath == null) {
            inClasspath = Resource.class.getResource(filename);
        }
        if (inClasspath == null) {
            inClasspath = Resource.getURLOrNull(filename);
        }
        if (inClasspath != null) {
            log.info((Object)("Chargement du fichier de config: " + inClasspath));
            result.load(inClasspath.openStream());
            result = new Properties(result);
        }
        if ((etcConfig = new File("/etc/" + filename)).exists()) {
            log.info((Object)("Chargement du fichier de config: " + etcConfig));
            result.load(etcConfig.toURI().toURL().openStream());
            result = new Properties(result);
        }
        if ((config = new File(filename)).exists()) {
            log.info((Object)("Chargement du fichier de config: " + config));
            result.load(config.toURI().toURL().openStream());
            result = new Properties(result);
        }
        return result;
    }

    public static List<URL> getURLs(String pattern) {
        return Resource.getURLs(pattern, (URLClassLoader)null);
    }

    public static URL[] getURLs(URLClassLoader classLoader) {
        return ClassLoaderUtil.getURLs(classLoader);
    }

    public static List<URL> getURLs(String pattern, URLClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        }
        URL[] arrayURL = ClassLoaderUtil.getURLs(classLoader);
        return Resource.getURLs(pattern, arrayURL);
    }

    public static List<URL> getURLs(String pattern, URL ... arrayURL) {
        URL jarURL;
        long t0 = System.nanoTime();
        HashList<URL> urlList = new HashList<URL>();
        if (arrayURL.length == 1 && Resource.isJar((jarURL = arrayURL[0]).toString())) {
            try {
                arrayURL = Resource.getClassPathURLsFromJarManifest(jarURL);
            }
            catch (Exception e) {
                log.warn((Object)e);
                arrayURL = new URL[]{jarURL};
            }
        }
        if (log.isDebugEnabled()) {
            for (URL url : arrayURL) {
                log.debug((Object)("found url " + url));
            }
        }
        for (URL urlFile : arrayURL) {
            String fileName = null;
            try {
                fileName = urlFile.toURI().getPath();
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)e);
                }
                fileName = urlFile.getFile();
            }
            File file = new File(fileName.replaceAll("%20", " "));
            if (!file.exists()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Can't find file " + file + " (" + fileName + ")"));
                continue;
            }
            if (Resource.isJar(fileName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("jar to search " + file));
                }
                urlList.addAll(Resource.getURLsFromJar(file, pattern));
                continue;
            }
            if (file.isDirectory()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("directory to search " + file));
                }
                urlList.addAll(Resource.getURLsFromDirectory(file, pattern));
                continue;
            }
            if (!Resource.isZip(fileName)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("zip to search " + file));
            }
            urlList.addAll(Resource.getURLsFromZip(file, pattern));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("search URLs pattern: " + pattern + " in " + arrayURL.length + " urls in " + StringUtil.convertTime(System.nanoTime() - t0)));
        }
        return urlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] getClassPathURLsFromJarManifest(URL jarURL) throws IOException, URISyntaxException {
        URL[] result;
        ZipFile jar = null;
        try {
            String jarPath = jarURL.toURI().getPath();
            File jarFile = new File(jarPath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("class-path jar to scan " + jarPath));
            }
            jar = new JarFile(jarFile);
            File container = jarFile.getParentFile();
            Manifest mf = ((JarFile)jar).getManifest();
            String classPath = null;
            if (mf != null && mf.getMainAttributes() != null) {
                classPath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            }
            String[] paths = classPath != null ? classPath.split(" ") : new String[]{};
            result = new URL[paths.length + 1];
            result[0] = jarURL;
            for (int i = 0; i < paths.length; ++i) {
                String s = paths[i];
                if (s.indexOf(58) != -1) {
                    result[i + 1] = new URL(s);
                    continue;
                }
                File path = s.startsWith(".") || !s.startsWith("/") ? new File(container, s) : new File(s);
                if (log.isDebugEnabled()) {
                    log.debug((Object)path);
                }
                result[i + 1] = path.toURI().toURL();
            }
            jar.close();
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
        return result;
    }

    public static List<URL> getURLsFromZip(File zipFile, String pattern) {
        try {
            ZipEntry entry;
            if (log.isTraceEnabled()) {
                log.trace((Object)("search '" + pattern + "' in " + zipFile));
            }
            ArrayList<URL> result = new ArrayList<URL>();
            FileInputStream in = new FileInputStream(zipFile);
            ZipInputStream zis = new ZipInputStream(in);
            while (zis.available() != 0 && (entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("zipFile: " + zipFile + " name: " + name));
                }
                if (pattern != null && !name.matches(pattern)) continue;
                URL url = Resource.getURL(name);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("zipFile: " + zipFile + " url: " + url));
                }
                result.add(url);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("found with pattern '" + pattern + "' : " + result));
            }
            return result;
        }
        catch (IOException eee) {
            throw new ResourceException(I18n._((String)"nuitonutil.error.get.url.from.zip", (Object[])new Object[]{zipFile.getAbsolutePath(), eee.getMessage()}));
        }
    }

    public static List<URL> getURLsFromJar(File jarfile, String pattern) {
        try {
            ZipEntry entry;
            if (log.isTraceEnabled()) {
                log.trace((Object)("search '" + pattern + "' in " + jarfile));
            }
            ArrayList<URL> result = new ArrayList<URL>();
            FileInputStream in = new FileInputStream(jarfile);
            ZipInputStream zis = new ZipInputStream(in);
            while (zis.available() != 0 && (entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("jarfile: " + jarfile + " name: " + name));
                }
                if (pattern != null && !name.matches(pattern)) continue;
                URL url = Resource.getURL(name);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("jarfile: " + jarfile + " url: " + url));
                }
                result.add(url);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("found with pattern '" + pattern + "' : " + result));
            }
            return result;
        }
        catch (IOException eee) {
            throw new ResourceException(I18n._((String)"nuitonutil.error.get.url.from.zip", (Object[])new Object[]{jarfile.getAbsolutePath(), eee.getMessage()}));
        }
    }

    public static List<URL> getURLsFromDirectory(File repository, String pattern) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("search '" + pattern + "' in " + repository));
            }
            HashList<URL> urlList = new HashList<URL>();
            File[] filesList = repository.listFiles();
            if (filesList != null) {
                for (File file : filesList) {
                    String name = file.getAbsolutePath();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("directory: " + repository + " name: " + name));
                    }
                    if (file.exists() && file.isDirectory()) {
                        urlList.addAll(Resource.getURLsFromDirectory(file, pattern));
                        continue;
                    }
                    if (pattern != null && !name.matches(pattern)) continue;
                    URL url = file.toURI().toURL();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("directory: " + repository + " url: " + url));
                    }
                    urlList.add(url);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("found with pattern '" + pattern + "' : " + urlList));
            }
            return urlList;
        }
        catch (MalformedURLException eee) {
            throw new ResourceException(I18n._((String)"nuitonutil.error.convert.file.to.url", (Object[])new Object[]{repository + " (pattern " + pattern + ") ", eee.getMessage()}));
        }
    }

    public static boolean isJar(String name) {
        if (name != null && name.length() > 4) {
            String ext = name.substring(name.length() - 4, name.length());
            return ".jar".equalsIgnoreCase(ext);
        }
        return false;
    }

    public static boolean isZip(String name) {
        if (name != null && name.length() > 4) {
            String ext = name.substring(name.length() - 4, name.length());
            return ".zip".equalsIgnoreCase(ext);
        }
        return false;
    }

    public static boolean isPrimitive(Class clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Byte.class || clazz == Character.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class;
    }

    public static Class getPrimitiveClass(Class clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Void.class) {
            return Void.TYPE;
        }
        return null;
    }

    public static boolean containsDirectDirectory(URL url, String directory) throws IOException {
        String fileName = url.getFile();
        File file = new File(fileName.replaceAll("%20", " "));
        if (!file.exists()) {
            return false;
        }
        if (Resource.isJar(fileName) || Resource.isZip(fileName)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("zip to search " + file));
            }
            return new ZipFile(file).getEntry(directory + '/') != null;
        }
        if (file.isDirectory()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("directory to search " + file));
            }
            return new File(file, directory).exists();
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)I18n._((String)"nuitonutil.error.unknown.url.type", (Object[])new Object[]{url}));
        }
        return false;
    }
}

