/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: URLConverter.java 1851 2010-05-11 11:24:21Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-1.4.2/src/main/java/org/nuiton/util/converter/URLConverter.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.util.converter;

import org.apache.commons.beanutils.ConversionException;
import static org.apache.commons.logging.LogFactory.getLog;
import static org.nuiton.i18n.I18n._;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;

/**
 * classe pour convertir une chaine en un objet URL.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3 (replace {@code org.nuiton.util.URLConverter}).
 */
public class URLConverter implements Converter {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static Log log = getLog(URLConverter.class);

    @Override
    public Object convert(Class aClass, Object value) {
        if (value == null) {
            throw new ConversionException(
                    _("nuitonutil.error.convertor.noValue", this));
        }
        if (isEnabled(aClass)) {
            Object result;
            if (isEnabled(value.getClass())) {
                result = value;
                return result;
            }
            if (value instanceof String) {
                result = valueOf((String) value);
                return result;
            }
        }
        throw new ConversionException(
               _("nuitonutil.error.no.convertor", aClass.getName(), value));
    }

    protected URL valueOf(String value) {
        try {
            URL result;
            result = new URL(value);
            return result;
        } catch (MalformedURLException e) {
            throw new ConversionException(
                    _("nuitonutil.error.url.convertor", value, this, e.getMessage()));
        }
    }

    public URLConverter() {
        log.info(this);
    }

    protected boolean isEnabled(Class<?> aClass) {
        return URL.class.equals(aClass);
    }

    public Class<?> getType() {
        return URL.class;
    }


}
