/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.beans;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.beans.BinderModel;

public class Binder<I, O>
implements Serializable {
    private static final Log log = LogFactory.getLog(Binder.class);
    private static final long serialVersionUID = 1L;
    protected BinderModel<I, O> model;

    public Map<String, Object> obtainProperties(I source, String ... propertyNames) {
        if (source == null) {
            return Collections.emptyMap();
        }
        propertyNames = this.getProperties(propertyNames);
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (String sourceProperty : propertyNames) {
            try {
                Method readMethod = this.model.getSourceReadMethod(sourceProperty);
                Object read = readMethod.invoke(source, new Object[0]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property " + sourceProperty + ", type : " + readMethod.getReturnType() + ", value = " + read));
                }
                if (readMethod.getReturnType().isPrimitive() && ObjectUtil.getNullValue(readMethod.getReturnType()).equals(read)) {
                    read = null;
                }
                if (read == null) continue;
                result.put(sourceProperty, read);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public void copy(I source, O target, String ... propertyNames) throws NullPointerException {
        if (target == null) {
            throw new NullPointerException("parameter 'target' can no be null");
        }
        for (String sourceProperty : propertyNames = this.getProperties(propertyNames)) {
            String targetProperty = this.model.getTargetProperty(sourceProperty);
            try {
                Object read = null;
                Method readMethod = this.model.getSourceReadMethod(sourceProperty);
                if (source != null) {
                    read = readMethod.invoke(source, new Object[0]);
                }
                if (read == null) {
                    read = ObjectUtil.getNullValue(readMethod.getReturnType());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property " + sourceProperty + ", type : " + readMethod.getReturnType() + ", value = " + read));
                }
                this.model.getTargetWriteMethod(targetProperty).invoke(target, read);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected String[] getProperties(String ... propertyNames) {
        if (propertyNames.length == 0) {
            propertyNames = this.model.getSourceDescriptors();
        } else {
            for (String propertyName : propertyNames) {
                if (this.model.containsSourceProperty(propertyName)) continue;
                throw new IllegalArgumentException("property '" + propertyName + "' is not known by binder");
            }
        }
        return propertyNames;
    }

    protected BinderModel<I, O> getModel() {
        return this.model;
    }

    protected void setModel(BinderModel<?, ?> model) {
        this.model = model;
    }
}

