/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.EnumSet;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EnumConverter
implements Converter {
    static Log log = LogFactory.getLog(EnumConverter.class);
    protected Object defaultValue;
    protected boolean useDefault;
    protected Class<?> enumType;

    public Object convert(Class aClass, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(I18n._("nuitonutil.error.convertor.noValue", this));
        }
        if (EnumConverter.isEnabled(aClass, this.enumType)) {
            if (EnumConverter.isEnabled(value.getClass(), this.enumType)) {
                Object result = value;
                return result;
            }
            if (value instanceof String) {
                Object result;
                try {
                    result = this.valueOf(aClass, value);
                }
                catch (IllegalArgumentException e) {
                    result = this.convertFromOrdinal(aClass, value);
                }
                return result;
            }
            if (value instanceof Integer) {
                Object result = this.convertFromOrdinal(aClass, value);
                return result;
            }
        }
        throw new ConversionException(I18n._("nuitonutil.error.no.convertor", aClass.getName(), value));
    }

    public EnumConverter(Class<?> enumType, Object defaultValue) {
        this.enumType = enumType;
        this.defaultValue = defaultValue;
        boolean bl = this.useDefault = defaultValue != null;
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.toString() + '<' + enumType + '>'));
        }
    }

    public EnumConverter(Class<?> enumType) {
        this(enumType, null);
    }

    protected static boolean isEnabled(Class<?> aClass, Class<?> enumType) {
        return aClass != null && aClass.isEnum() && aClass == enumType;
    }

    protected Object convertFromOrdinal(Class<?> aClass, Object value) {
        Enum result;
        block3: {
            result = null;
            try {
                int ordinal = Integer.valueOf(value + "");
                EnumSet<?> vals = this.allOf(aClass);
                if (ordinal <= -1 || ordinal >= vals.size()) break block3;
                for (Enum val : vals) {
                    if (val.ordinal() != ordinal) continue;
                    result = val;
                    break;
                }
            }
            catch (NumberFormatException e1) {
                result = null;
            }
        }
        return result;
    }

    protected Object valueOf(Class<?> aClass, Object value) {
        Object result = Enum.valueOf(aClass, (String)value);
        return result;
    }

    protected EnumSet<?> allOf(Class<?> aClass) {
        EnumSet<?> vals = EnumSet.allOf(aClass);
        return vals;
    }

    public Class<?> getType() {
        return this.enumType;
    }
}

