/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateUtils {
    public static final String DEFAULT_PATTERN = "dd/MM/yyyy";
    public static final String MONTH_PATTERN = "MM/yyyy";

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(date);
    }

    public static String formatDate(Date date, String pattern, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, locale);
        return simpleDateFormat.format(date);
    }

    public static Date parseDate(String date, String pattern) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        Date result = simpleDateFormat.parse(date);
        return result;
    }

    public static Date createDate(int dd, int mm, int yy) {
        GregorianCalendar calendar = new GregorianCalendar(yy, mm - 1, dd);
        return calendar.getTime();
    }

    public static Date createDateAfterToday(int ddStep, int mmStep, int yyStep) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        ((Calendar)calendar).add(5, ddStep);
        ((Calendar)calendar).add(2, mmStep);
        ((Calendar)calendar).add(1, yyStep);
        return calendar.getTime();
    }

    public static Date setLastDayOfMonth(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int maximum = ((Calendar)calendar).getActualMaximum(5);
        calendar.set(5, maximum);
        return calendar.getTime();
    }

    public static Date setFirstDayOfMonth(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static boolean between(Date myDate, Date beforeDate, Date afterDate) {
        if (myDate == null) {
            return false;
        }
        boolean result = true;
        result &= myDate.after(beforeDate) || myDate.equals(beforeDate);
        return result &= afterDate == null || myDate.before(afterDate) || myDate.equals(afterDate);
    }

    public static boolean currentPeriod(Date beforeDate, Date afterDate) {
        return DateUtils.between(new Date(), beforeDate, afterDate);
    }

    public static int getMonth(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static int getDifferenceInDays(Date beginDate, Date endDate) {
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        return (int)Math.ceil((end - begin) / 86400000L);
    }

    public static String getMonthLibelle(int monthNumber, Locale locale) {
        return new DateFormatSymbols(locale).getMonths()[monthNumber - 1];
    }

    public static String getMonthLibelle(int monthNumber) {
        return DateUtils.getMonthLibelle(monthNumber, Locale.getDefault());
    }
}

