/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.updater;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.nuiton.util.config.ApplicationConfig;
import org.nuiton.util.updater.AbstractApplicationUpdaterAction;
import org.nuiton.util.updater.ApplicationInfo;
import org.nuiton.util.updater.ApplicationUpdater;
import org.nuiton.util.updater.ApplicationUpdaterCallback;
import org.nuiton.util.updater.DownloadMonitor;
import org.nuiton.util.updater.UpdateInvalidArchiveLayoutException;
import org.nuiton.util.updater.UpdateNotFoundException;

@Deprecated
public class ApplicationUpdaterActionUpdate
extends AbstractApplicationUpdaterAction {
    private static final Log log = LogFactory.getLog(ApplicationUpdaterActionUpdate.class);
    protected ApplicationUpdaterCallback callback;
    protected DownloadMonitor downloadMonitor;
    protected File destDir;

    public ApplicationUpdaterActionUpdate(ApplicationConfig config, String vfsPropertiesUrl, File currentDir, File destDir, DownloadMonitor downloadMonitor, ApplicationUpdaterCallback callback) {
        super(config, vfsPropertiesUrl, currentDir);
        this.destDir = destDir;
        this.downloadMonitor = downloadMonitor;
        this.callback = callback;
    }

    @Override
    public void run() {
        block7: {
            try {
                FileSystemOptions vfsConfig = this.getVFSConfig(this.config);
                ApplicationConfig releaseConfig = this.getUpdaterConfig(vfsConfig, this.vfsPropertiesUrl);
                Map<String, ApplicationInfo> appToUpdate = this.getVersions(releaseConfig, false, this.destDir);
                if (this.callback != null) {
                    appToUpdate = this.callback.updateToDo(appToUpdate);
                }
                HashMap<String, Exception> appUpdateError = new HashMap<String, Exception>();
                for (Map.Entry<String, ApplicationInfo> appInfo : appToUpdate.entrySet()) {
                    String app = appInfo.getKey();
                    ApplicationInfo info = appInfo.getValue();
                    try {
                        this.doUpdate(vfsConfig, appInfo.getValue());
                    }
                    catch (Exception eee) {
                        this.onUpdateError(app, info, appUpdateError, eee);
                    }
                }
                if (this.callback != null) {
                    this.callback.updateDone(appToUpdate, appUpdateError);
                }
            }
            catch (Exception eee) {
                log.warn((Object)"Can't update");
                log.info((Object)"Application update aborted because: ", (Throwable)eee);
                if (this.callback == null) break block7;
                this.callback.aborted(this.vfsPropertiesUrl, eee);
            }
        }
    }

    protected void onUpdateError(String app, ApplicationInfo info, Map<String, Exception> appUpdateError, Exception eee) {
        appUpdateError.put(app, eee);
        log.warn((Object)String.format("Can't update application '%s' with url '%s'", app, info.url));
        log.debug((Object)"Application update aborted because: ", (Throwable)eee);
        try {
            File dest = new File(info.destDir, info.name);
            if (dest.exists()) {
                log.debug((Object)String.format("Cleaning destination directory due to error '%s'", dest));
                FileUtils.deleteDirectory((File)dest);
            }
        }
        catch (Exception doNothing) {
            log.debug((Object)"Can't clean directory", (Throwable)doNothing);
        }
    }

    protected void doUpdate(FileSystemOptions vfsConfig, ApplicationInfo info) throws Exception {
        if (info.destDir != null) {
            File dest = new File(info.destDir, info.name);
            String url = this.toVfsURL(info.url);
            if (info.needAuthentication) {
                url = StringUtils.replaceOnce((String)url, (String)"://", (String)String.format("://%s:%s@", info.login, new String(info.password)));
            }
            if (this.callback != null) {
                this.callback.startUpdate(info);
            }
            String archiveType = url.substring(0, url.indexOf(58));
            File archive = this.downloadUpdate(vfsConfig, info, url.substring(archiveType.length() + 1));
            this.explodeUpdate(vfsConfig, info, archiveType, archive, dest);
            ApplicationUpdater.createVersionFile(dest, info.newVersion);
            log.info((Object)String.format("Application '%s' is uptodate with version '%s' in '%s'", info.name, info.newVersion, info.destDir));
        } else {
            log.info((Object)String.format("Update for '%s' aborted because destination dir is set to null", info.name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File downloadUpdate(FileSystemOptions vfsConfig, ApplicationInfo info, String srcPath) throws IOException {
        FileSystemManager fsManager = VFS.getManager();
        FileObject source = fsManager.resolveFile(srcPath, vfsConfig);
        if (!source.exists()) {
            throw new UpdateNotFoundException(info);
        }
        File result = new File(FileUtils.getTempDirectory(), source.getName().getBaseName() + '_' + System.nanoTime());
        FileObject target = fsManager.toFileObject(result);
        InputStream input = source.getContent().getInputStream();
        try {
            OutputStream output = target.getContent().getOutputStream();
            try {
                int n;
                long inputSize = source.getContent().getSize();
                if (this.downloadMonitor != null) {
                    this.downloadMonitor.setSize(inputSize);
                }
                long count = 0L;
                byte[] buffer = new byte[1024];
                while (-1 != (n = input.read(buffer))) {
                    output.write(buffer, 0, n);
                    count += (long)n;
                    if (this.downloadMonitor == null) continue;
                    this.downloadMonitor.setCurrent(count);
                }
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
            input.close();
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
        return result;
    }

    protected void explodeUpdate(FileSystemOptions vfsConfig, ApplicationInfo info, String archiveType, File source, File target) throws FileSystemException, UpdateInvalidArchiveLayoutException {
        FileSystemManager fsManager = VFS.getManager();
        FileObject sourceObject = fsManager.resolveFile(archiveType + ":" + source.getAbsolutePath(), vfsConfig);
        FileObject[] children = sourceObject.getChildren();
        if (children.length != 1) {
            throw new UpdateInvalidArchiveLayoutException(info, source);
        }
        FileObject targetObject = fsManager.toFileObject(target);
        targetObject.delete((FileSelector)new AllFileSelector());
        FileObject child = children[0];
        targetObject.copyFrom(child, (FileSelector)new AllFileSelector());
    }
}

