/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.profiling;

public class Unit {
    public static String format(double value, Memory source, Memory target, int precision) {
        double v = source.convertTo(target, value);
        String result = String.format("%,." + precision + "f", v);
        result = result + target.toString();
        return result;
    }

    public static String format(double value, Time source, Time target, int precision) {
        double v = source.convertTo(target, value);
        String result = String.format("%,." + precision + "f", v);
        result = result + target.toString();
        return result;
    }

    public static String format(double value, Memory source, int precision) {
        double tmp;
        Memory u = source;
        Memory target = source;
        double sign = value == 0.0 ? 1.0 : value / Math.abs(value);
        for (tmp = Math.abs(value); u != null && tmp > u.factor; tmp /= u.factor, u = u.next()) {
            target = u;
        }
        if (u != null) {
            target = u;
        }
        for (u = target.prev(); u != null && tmp < 1.0; tmp *= u.factor, u = u.prev()) {
            target = u;
        }
        String result = String.format("%,." + precision + "f", tmp *= sign);
        result = result + target.toString();
        return result;
    }

    public static String format(double value, Time source, int precision) {
        double tmp;
        Time u = source;
        Time target = source;
        double sign = value == 0.0 ? 1.0 : value / Math.abs(value);
        for (tmp = Math.abs(value); u != null && tmp > u.factor; tmp /= u.factor, u = u.next()) {
            target = u;
        }
        if (u != null) {
            target = u;
        }
        for (u = target.prev(); u != null && tmp < 1.0; tmp *= u.factor, u = u.prev()) {
            target = u;
        }
        String result = String.format("%,." + precision + "f", tmp *= sign);
        result = result + target.toString();
        return result;
    }

    public static enum Time {
        nano(1000000.0),
        milli(1000.0),
        s(60.0),
        m(60.0),
        h(24.0),
        d(1.0);

        private final double factor;

        private Time(double f) {
            this.factor = f;
        }

        public Time next() {
            Time[] values = Time.values();
            Time result = null;
            int next = this.ordinal() + 1;
            if (next < values.length) {
                result = values[next];
            }
            return result;
        }

        public Time prev() {
            Time[] values = Time.values();
            Time result = null;
            int prev = this.ordinal() - 1;
            if (prev >= 0) {
                result = values[prev];
            }
            return result;
        }

        public double convertTo(Time target, double value) {
            double result;
            block3: {
                block2: {
                    result = value;
                    if (this.compareTo(target) >= 0) break block2;
                    for (Time u = this; u != target; u = u.next()) {
                        result /= u.factor;
                    }
                    break block3;
                }
                if (this.compareTo(target) <= 0) break block3;
                Time u = this;
                while (u != target) {
                    u = u.prev();
                    result *= u.factor;
                }
            }
            return result;
        }
    }

    public static enum Memory {
        o(1024.0),
        Ko(1024.0),
        Mo(1024.0),
        Go(1024.0),
        To(1.0);

        private final double factor;

        private Memory(double f) {
            this.factor = f;
        }

        Memory next() {
            Memory[] values = Memory.values();
            Memory result = null;
            int next = this.ordinal() + 1;
            if (next < values.length) {
                result = values[next];
            }
            return result;
        }

        Memory prev() {
            Memory[] values = Memory.values();
            Memory result = null;
            int prev = this.ordinal() - 1;
            if (prev >= 0) {
                result = values[prev];
            }
            return result;
        }

        double convertTo(Memory target, double value) {
            double result;
            block3: {
                block2: {
                    result = value;
                    if (this.compareTo(target) >= 0) break block2;
                    for (Memory u = this; u != target; u = u.next()) {
                        result /= u.factor;
                    }
                    break block3;
                }
                if (this.compareTo(target) <= 0) break block3;
                Memory u = this;
                while (u != target) {
                    u = u.prev();
                    result *= u.factor;
                }
            }
            return result;
        }
    }
}

