/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.profiling;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;

public class Counter<E>
implements Iterable<Map.Entry<E, AtomicInteger>> {
    protected Map<E, AtomicInteger> data = new HashMap<E, AtomicInteger>();

    public void add(E e) {
        AtomicInteger v = this.data.get(e);
        if (v == null) {
            v = new AtomicInteger();
            this.data.put(e, v);
        }
        v.incrementAndGet();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<E, AtomicInteger> e : this) {
            result.append(e.getValue()).append("=[").append(e.getKey()).append("]").append(",");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    @Override
    public Iterator<Map.Entry<E, AtomicInteger>> iterator() {
        Comparator comparator = new Comparator<Map.Entry<E, AtomicInteger>>(){

            @Override
            public int compare(Map.Entry<E, AtomicInteger> o1, Map.Entry<E, AtomicInteger> o2) {
                return Integer.compare(o2.getValue().get(), o1.getValue().get());
            }
        };
        Set<Map.Entry<E, AtomicInteger>> entries = this.data.entrySet();
        TreeSet<Map.Entry<E, AtomicInteger>> sorted = new TreeSet<Map.Entry<E, AtomicInteger>>(comparator);
        sorted.addAll(entries);
        return sorted.iterator();
    }
}

