/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.profiling;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.spi.HttpServerProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.profiling.NuitonTrace;
import org.nuiton.profiling.StatisticMemory;

public class WebService {
    protected static StatisticMemory memoryStat = new StatisticMemory();
    protected InetSocketAddress inet;
    protected HttpServer server;

    public WebService(int port) {
        try {
            HttpServerProvider provider = HttpServerProvider.provider();
            this.inet = new InetSocketAddress(port);
            this.server = provider.createHttpServer(this.inet, 0);
            this.server.createContext("/", new WebHandler());
            this.server.createContext("/data/json", new DataJSONHandler());
            this.server.createContext("/data/csv", new DataCSVHandler());
            this.server.createContext("/api", new ApiHandler());
        }
        catch (Throwable eee) {
            System.err.println("Can't start web service on port " + port);
            eee.printStackTrace(System.err);
        }
    }

    public void start() {
        this.server.start();
        System.out.println("Nuiton profiling Server is listening on " + this.inet);
    }

    static class ApiHandler
    implements HttpHandler {
        ApiHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String requestMethod = exchange.getRequestMethod();
            if (requestMethod.equalsIgnoreCase("GET")) {
                String path = exchange.getRequestURI().getPath();
                if (StringUtils.endsWithIgnoreCase((CharSequence)path, (CharSequence)"clear")) {
                    Headers responseHeaders = exchange.getResponseHeaders();
                    responseHeaders.set("Content-Type", "text/plain");
                    exchange.sendResponseHeaders(200, 0L);
                    NuitonTrace.clearStatistics();
                    OutputStream responseBody = exchange.getResponseBody();
                    responseBody.write("ok".getBytes());
                    responseBody.close();
                } else if (StringUtils.endsWithIgnoreCase((CharSequence)path, (CharSequence)"gc")) {
                    Headers responseHeaders = exchange.getResponseHeaders();
                    responseHeaders.set("Content-Type", "text/plain");
                    exchange.sendResponseHeaders(200, 0L);
                    Runtime.getRuntime().gc();
                    OutputStream responseBody = exchange.getResponseBody();
                    responseBody.write("ok".getBytes());
                    responseBody.close();
                } else {
                    exchange.sendResponseHeaders(404, 0L);
                    exchange.close();
                }
            }
        }
    }

    static class DataCSVHandler
    implements HttpHandler {
        DataCSVHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String requestMethod = exchange.getRequestMethod();
            if (requestMethod.equalsIgnoreCase("GET")) {
                String csv;
                Headers responseHeaders = exchange.getResponseHeaders();
                responseHeaders.set("Content-Type", "text/plain");
                exchange.sendResponseHeaders(200, 0L);
                String path = exchange.getRequestURI().getPath();
                if (StringUtils.endsWithIgnoreCase((CharSequence)path, (CharSequence)"memory")) {
                    memoryStat.add(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
                    csv = memoryStat.exportCSV(null).toString();
                } else {
                    csv = NuitonTrace.trace.getStatisticsCSV();
                }
                OutputStream responseBody = exchange.getResponseBody();
                responseBody.write(csv.getBytes());
                responseBody.close();
            }
        }
    }

    static class DataJSONHandler
    implements HttpHandler {
        DataJSONHandler() {
        }

        protected String getCallback(HttpExchange exchange) {
            String result = null;
            URI uri = exchange.getRequestURI();
            String query = uri.getQuery();
            if (query != null) {
                String[] pairs;
                for (String pair : pairs = query.split("[&]")) {
                    String[] param = pair.split("[=]", 2);
                    if (param.length != 2 || !"callback".equalsIgnoreCase(param[0])) continue;
                    result = param[1];
                    break;
                }
            }
            return result;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String requestMethod = exchange.getRequestMethod();
            if (requestMethod.equalsIgnoreCase("GET")) {
                String json;
                Headers responseHeaders = exchange.getResponseHeaders();
                responseHeaders.set("Content-Type", "text/javascript");
                exchange.sendResponseHeaders(200, 0L);
                String jsoncallback = this.getCallback(exchange);
                String path = exchange.getRequestURI().getPath();
                if (StringUtils.endsWithIgnoreCase((CharSequence)path, (CharSequence)"memory")) {
                    memoryStat.add(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
                    json = "{" + memoryStat.exportJSON(null) + "}";
                } else {
                    json = NuitonTrace.trace.getStatisticsJson();
                }
                if (jsoncallback != null) {
                    json = jsoncallback + "(" + json + ")";
                }
                OutputStream responseBody = exchange.getResponseBody();
                responseBody.write(json.getBytes());
                responseBody.close();
            }
        }
    }

    static class WebHandler
    implements HttpHandler {
        public static final String filepath = "/org/nuiton/profiling/web/";

        WebHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String requestMethod = exchange.getRequestMethod();
            if (requestMethod.equalsIgnoreCase("GET")) {
                String path = exchange.getRequestURI().getPath();
                String file = StringUtils.substringAfterLast((String)path, (String)"/");
                file = (String)StringUtils.defaultIfBlank((CharSequence)file, (CharSequence)"index.html");
                URL resource = this.getClass().getResource(filepath + file);
                if (resource == null) {
                    exchange.sendResponseHeaders(404, 0L);
                    exchange.close();
                } else {
                    String ext = StringUtils.substringAfterLast((String)file, (String)".");
                    String type = StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)"mf") ? "text/cache-manifest" : (StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)"ico") ? "image/x-icon" : (StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)"js") ? "text/javascript" : "text/" + ext));
                    Headers responseHeaders = exchange.getResponseHeaders();
                    responseHeaders.set("Content-Type", type);
                    exchange.sendResponseHeaders(200, 0L);
                    InputStream in = resource.openStream();
                    ByteArrayOutputStream content = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)content);
                    OutputStream responseBody = exchange.getResponseBody();
                    responseBody.write(content.toByteArray());
                    responseBody.close();
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)content);
                }
            }
        }
    }
}

