/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixException;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import org.nuiton.math.matrix.gui.MatrixPopupMenu;
import org.nuiton.math.matrix.gui.MatrixTableModel;
import org.nuiton.math.matrix.gui.MatrixTableModelLinear;
import org.nuiton.math.matrix.gui.MatrixTableModelND;
import org.nuiton.util.ListenerSet;

public class MatrixPanelEditor
extends MatrixEditor
implements TableModelListener {
    private static final long serialVersionUID = 2097859265435050946L;
    private static final int DEFAULT_WIDTH = 150;
    private static final int DEFAULT_HEIGHT = 150;
    protected ListenerSet<MatrixPanelListener> listeners = new ListenerSet();
    protected JTable table;
    protected MatrixND m;
    protected MatrixTableModel tableModel;
    protected JScrollPane editArea;
    protected MatrixPopupMenu popupMenu;
    protected boolean linearModel = false;
    protected boolean linearModelShowDefault = false;
    @Deprecated
    protected boolean enabled = true;
    @Deprecated
    protected boolean visible = true;
    protected boolean dimensionEdit;
    protected JButton bEdit = null;

    public MatrixPanelEditor(MatrixND m, boolean dimensionEdit) {
        this(dimensionEdit, 150, 150);
        this.setMatrix(m);
    }

    public MatrixPanelEditor(boolean dimensionEdit, int width, int height) {
        this.dimensionEdit = dimensionEdit;
        this.setPreferredSize(new Dimension(width, height));
        this.initObjet();
    }

    public MatrixPanelEditor(boolean dimensionEdit) {
        this(dimensionEdit, 150, 150);
    }

    public MatrixPanelEditor() {
        this(false);
    }

    protected MatrixFactory getFactory() {
        return MatrixFactory.getInstance();
    }

    @Deprecated
    public void addMatrixListener(MatrixPanelListener l) {
        this.listeners.add((Object)l);
    }

    public void addMatrixPanelListener(MatrixPanelListener l) {
        this.listeners.add((Object)l);
    }

    public void removeMatrixPanelListener(MatrixPanelListener l) {
        this.listeners.remove((Object)l);
    }

    public MatrixPanelListener[] getMatrixPanelListeners() {
        ArrayList r = new ArrayList();
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            r.add(itr.next());
        }
        return r.toArray(new MatrixPanelListener[r.size()]);
    }

    protected void initObjet() {
        this.setLayout(new BorderLayout());
        this.editArea = new JScrollPane();
        this.add((Component)this.editArea, "Center");
        this.initDimensionEdit();
    }

    @Override
    public JButton getButtonEdit() {
        if (this.bEdit == null) {
            this.bEdit = new JButton(I18n._((String)"lutinmatrix.create.matrix.button"));
            this.bEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String dim = JOptionPane.showInputDialog(null, I18n._((String)"lutinmatrix.create.matrix.message"), I18n._((String)"lutinmatrix.create.matrix.title"), -1);
                    if (dim != null) {
                        String[] sdim = dim.split(";");
                        int[] idim = new int[sdim.length];
                        for (int i = 0; i < idim.length; ++i) {
                            idim[i] = Integer.parseInt(sdim[i]);
                        }
                        MatrixPanelEditor.this.setMatrix(MatrixPanelEditor.this.getFactory().create(idim));
                    }
                }
            });
            this.add((Component)this.bEdit, "South");
        }
        return this.bEdit;
    }

    @Override
    public Boolean isLinearModel() {
        return this.linearModel;
    }

    @Override
    public void setLinearModel(Boolean linearModel) {
        this.linearModel = linearModel;
        this.initObject(this.m);
    }

    @Override
    public Boolean isLinearModelShowDefault() {
        return this.linearModelShowDefault;
    }

    @Override
    public void setLinearModelShowDefault(Boolean linearModelShowDefault) {
        this.linearModelShowDefault = linearModelShowDefault;
        this.initObject(this.m);
    }

    public boolean isDimensionEdit() {
        return this.dimensionEdit;
    }

    public void setDimensionEdit(boolean v) {
        this.dimensionEdit = v;
        this.initDimensionEdit();
    }

    protected void initDimensionEdit() {
        this.getButtonEdit().setVisible(this.dimensionEdit);
    }

    protected void initObject(MatrixND m) {
        if (m == null) {
            this.editArea.setViewportView(null);
        } else {
            JTable t = this.getTable();
            this.tableModel = this.isLinearModel() != false ? new MatrixTableModelLinear(m, this.isLinearModelShowDefault()) : new MatrixTableModelND(m);
            t.getModel().removeTableModelListener(this);
            this.tableModel.addTableModelListener(this);
            t.setModel(this.tableModel);
            t.setDefaultRenderer(String.class, this.tableModel.getMatrixCellRenderer());
            this.editArea.setViewportView(t);
            this.add((Component)this.editArea, "Center");
        }
        this.setEnabled(this.enabled);
        this.setVisible(this.visible);
        this.repaint();
    }

    @Override
    public JTable getTable() {
        if (this.table == null) {
            this.popupMenu = new MatrixPopupMenu(this);
            this.table = new JTable(){
                private static final long serialVersionUID = 1L;

                @Override
                public void processMouseEvent(MouseEvent event) {
                    if (event.isPopupTrigger()) {
                        MatrixPanelEditor.this.popupMenu.show(event.getComponent(), event.getX(), event.getY());
                    }
                    super.processMouseEvent(event);
                }
            };
            this.table.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copy");
            this.table.getActionMap().put("copy", this.popupMenu.getSendToClipBoardSelectionCopyAction());
            this.table.getInputMap().put(KeyStroke.getKeyStroke(86, 2), "paste");
            this.table.getActionMap().put("paste", this.popupMenu.getSendToClipBoardCurrentPasteAction());
            this.table.setAutoResizeMode(0);
            this.table.setSelectionMode(1);
            this.table.setCellSelectionEnabled(true);
        }
        return this.table;
    }

    @Override
    public void setMatrix(MatrixND m) throws MatrixException {
        this.initObject(m);
        this.m = m;
        this.fireEvent();
    }

    @Override
    public MatrixND getMatrix() {
        return this.m;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.tableModel != null) {
            this.tableModel.setEnabled(enabled);
        }
        if (this.table != null) {
            this.table.setEnabled(enabled);
        }
        super.setEnabled(enabled);
        if (!enabled && this.dimensionEdit) {
            this.dimensionEdit = false;
            this.initDimensionEdit();
        }
        if (!enabled) {
            this.editArea.setViewportView(null);
        }
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.table != null) {
            this.table.setVisible(visible);
        }
        super.setVisible(visible);
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.fireEvent();
    }

    @Override
    protected void fireEvent() {
        MatrixPanelEvent e = new MatrixPanelEvent(this);
        for (MatrixPanelListener l : this.listeners) {
            l.matrixChanged(e);
        }
    }

    public static void main(String[] args) {
        I18n.init((String)"fr", (String)"FR");
        JFrame frame = new JFrame();
        MatrixPanelEditor ed = null;
        try {
            ed = new MatrixPanelEditor(true);
            ed.setLinearModel(false);
            frame.getContentPane().add(ed);
            List<String> sem1 = Arrays.asList("toto", "titi", "tutu");
            List<String> sem2 = Arrays.asList("tata", "tete", "tyty");
            List<String> sem3 = Arrays.asList("riri", "fifi", "loulou");
            MatrixND m = MatrixFactory.getInstance().create("name", new List[]{sem1, sem2, sem3}, new String[]{"dim1", "dim2", "dim3"});
            m.setValue(0, 0, 0, 1.0);
            m.setValue(0, 1, 0, 2.0);
            m.setValue(0, 0, 1, 3.0);
            ed.setMatrix(m);
        }
        catch (MatrixException e) {
            e.printStackTrace();
            System.exit(0);
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }
}

