/* *##% NuitonMatrix
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.math.matrix;

import java.util.List;

/**
 * MatrixIteratorImpl.
 *
 * Created: 28 oct. 2004
 *
 * @author Benjamin Poussin <poussin@codelutin.com>
 * @version $Revision: 168 $
 *
 * Mise a jour: $Date: 2009-07-17 18:18:45 +0200 (ven., 17 juil. 2009) $
 * par : $Author: echatellier $
 */
public class MatrixIteratorImpl implements MatrixIterator { // MatrixIteratorImpl

    protected BasicMatrixIterator iterator = null;
    protected List<?>[] semantics = null;
    protected int pos = 0;

    /**
     * @param iterator la matrice sur lequel l'iterator doit travailler
     * @param semantics la semantique de matrix, si matrix n'a pas de semantique
     *            alors il faut passer null
     */
    public MatrixIteratorImpl(BasicMatrixIterator iterator, List<?>[] semantics) {
        this.iterator = iterator;
        this.semantics = semantics;
        pos = 0;
    }

    public boolean hasNext() {
        return iterator.hasNext();
    }

    public boolean next() {
        return iterator.next();
    }

    public int[] getCoordinates() {
        return iterator.getCoordinates();
    }

    public double getValue() {
        return iterator.getValue();
    }

    public void setValue(double value) {
        iterator.setValue(value);
    }

    public Object[] getSemanticsCoordinates() {
        Object[] result = null;
        if (semantics != null) {
            int[] coordinates = getCoordinates();
            result = MatrixHelper.dimensionToSemantics(semantics,
                    coordinates);
        }
        return result;
    }

} // MatrixIteratorImpl

