/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.j2r;

import java.io.File;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;

public abstract class REngineAbstract
implements REngine {
    protected Boolean autocommit = true;

    @Override
    public void loadRData(File directory) throws RException {
        this.setwd(directory);
        this.voidEval("load(\".RData\")");
    }

    @Override
    public void loadRData(File directory, String fileName) throws RException {
        this.setwd(directory);
        this.voidEval(String.format("load(\"%s.RData\")", fileName));
    }

    @Override
    public void loadRData(String fileName) throws RException {
        this.voidEval(String.format("load(\"%s.RData\")", fileName));
    }

    @Override
    public void saveRData(File directory) throws RException {
        this.setwd(directory);
        this.voidEval("save.image()");
    }

    @Override
    public void saveRData(String filename) throws RException {
        this.voidEval(String.format("save.image(file=\"%s.RData\")", filename));
    }

    @Override
    public void saveRData(File directory, String fileName) throws RException {
        this.setwd(directory);
        this.voidEval(String.format("save.image(file=\"%s.RData\")", fileName));
    }

    @Override
    public void setwd(File directory) throws RException {
        this.voidEval(String.format("setwd(\"%s\")", directory.getAbsolutePath().replaceAll("\\\\", "/")));
    }

    @Override
    public File getwd() throws RException {
        String directory = (String)this.eval("getwd()");
        return new File(directory);
    }

    @Override
    public void dput(String rObject, String outputFileName) throws RException {
        this.voidEval(String.format("dput(%s,file=\"%s\")", rObject, outputFileName));
    }

    @Override
    public void dget(String rObject, String inputFileName) throws RException {
        this.voidEval(String.format("%s <- dget(\"%s\")", rObject, inputFileName));
    }

    @Override
    public void dput(String rObject, File outputFile) throws RException {
        File workingdir = this.getwd();
        this.setwd(outputFile.getParentFile());
        this.voidEval(String.format("dput(%s,file=\"%s\")", rObject, outputFile.getName()));
        this.setwd(workingdir);
    }

    @Override
    public void dget(String rObject, File inputFile) throws RException {
        File workingdir = this.getwd();
        this.setwd(inputFile.getParentFile());
        this.voidEval(String.format("%s <- dget(\"%s\")", rObject, inputFile.getName()));
        this.setwd(workingdir);
    }

    @Override
    public void remove(String rObject) throws RException {
        this.voidEval(String.format("remove(%s)", rObject));
    }

    @Override
    public void mv(String source, String destination) throws RException {
        this.cp(source, destination);
        this.remove(source);
    }

    @Override
    public void cp(String source, String destination) throws RException {
        this.voidEval(destination + "<-" + source);
    }

    @Override
    public String[] ls() throws RException {
        String[] rObjects = (String[])this.eval("ls()");
        return rObjects;
    }

    @Override
    public void clearSession() throws RException {
        this.voidEval("rm(list=ls())");
    }

    @Override
    public void setAutoCommit(Boolean autocommit) throws RException {
        if (!this.autocommit.booleanValue() && autocommit.booleanValue()) {
            this.commit();
        }
        this.autocommit = autocommit;
    }

    @Override
    public Boolean isAutoCommit() {
        return this.autocommit;
    }

    @Override
    public void plot(String filename, String x, String y, String type, String main, String sub, String xlab, String ylab, String asp) throws RException {
        this.eval("jpeg(\"" + filename + ".jpg\")");
        StringBuilder rinstruction = new StringBuilder("plot(");
        if (x == null || x.isEmpty()) {
            throw new IllegalArgumentException("x argument must be filled");
        }
        rinstruction.append(x);
        if (y != null && !y.isEmpty()) {
            rinstruction.append(",y=");
            rinstruction.append(y);
        }
        if (type != null) {
            rinstruction.append(",type=\"");
            rinstruction.append(type);
            rinstruction.append("\"");
        }
        if (main != null) {
            rinstruction.append(",main=\"");
            rinstruction.append(main);
            rinstruction.append("\"");
        }
        if (sub != null) {
            rinstruction.append(",sub=\"");
            rinstruction.append(sub);
            rinstruction.append("\"");
        }
        if (xlab != null) {
            rinstruction.append(",xlab=\"");
            rinstruction.append(xlab);
            rinstruction.append("\"");
        }
        if (ylab != null) {
            rinstruction.append(",ylab=\"");
            rinstruction.append(ylab);
            rinstruction.append("\"");
        }
        if (asp != null) {
            rinstruction.append(",asp=");
            rinstruction.append(asp);
            rinstruction.append("\"");
        }
        rinstruction.append(")");
        this.eval(rinstruction.toString());
        this.eval("dev.off()");
    }
}

