/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.j2r.jni;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RNative {
    private static Log log = LogFactory.getLog(RNative.class);
    public static final String RESOURCE_PREFIX;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_LINUX;

    static String getNativeLibraryResourcePrefix() {
        return RNative.getNativeLibraryResourcePrefix(System.getProperty("os.arch"));
    }

    static String getNativeLibraryResourcePrefix(String arch) {
        String osPrefix;
        if ("i386".equals(arch = arch.toLowerCase().trim())) {
            arch = "x86";
        } else if ("x86_64".equals(arch) || "amd64".equals(arch)) {
            arch = "x86-64";
        }
        if (IS_WINDOWS) {
            osPrefix = "win32-" + arch;
        } else if (IS_LINUX) {
            osPrefix = "linux-" + arch;
        } else {
            throw new UnsatisfiedLinkError("Unsupported plaform/arch");
        }
        return osPrefix;
    }

    static boolean loadNativeRLibraryFromClasspath() {
        boolean result;
        block5: {
            result = false;
            try {
                String libName = "/" + RESOURCE_PREFIX + "/" + System.mapLibraryName("jri");
                File lib = RNative.extractFromResourcePath(libName, RNative.class.getClassLoader());
                if (lib == null && lib == null) {
                    throw new UnsatisfiedLinkError("Could not find R native support");
                }
                System.load(lib.getAbsolutePath());
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loaded jri native library from classpath (" + libName + ")"));
                }
                result = true;
            }
            catch (IOException ex) {
                throw new UnsatisfiedLinkError(ex.getMessage());
            }
            catch (UnsatisfiedLinkError ex) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Can't load jri lib dependencies. R not found or not installed", (Throwable)ex);
            }
        }
        return result;
    }

    public static File extractFromResourcePath(String name, ClassLoader loader) throws IOException {
        InputStream is;
        String resourcePath;
        if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            loader = RNative.class.getClassLoader();
        }
        if ((resourcePath = name).startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if ((is = loader.getResourceAsStream(resourcePath)) == null) {
            throw new IOException("Can't obtain InputStream for " + resourcePath);
        }
        File lib = null;
        FileOutputStream fos = null;
        try {
            int count;
            lib = File.createTempFile("nuiton-j2r-", IS_WINDOWS ? ".dll" : null);
            lib.deleteOnExit();
            fos = new FileOutputStream(lib);
            byte[] buf = new byte[1024];
            while ((count = is.read(buf, 0, buf.length)) > 0) {
                fos.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to create temporary file for " + name + " library: " + e.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        return lib;
    }

    static {
        String osName = System.getProperty("os.name");
        IS_WINDOWS = osName.startsWith("Windows");
        IS_LINUX = osName.startsWith("Linux");
        RESOURCE_PREFIX = RNative.getNativeLibraryResourcePrefix();
    }
}

