/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.j2r.jni;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.REngineAbstract;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.types.RDataFrame;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RList;
import org.rosuda.JRI.Rengine;

public class RJniEngine
extends REngineAbstract
implements REngine {
    private Log log = LogFactory.getLog(RJniEngine.class);
    private static Rengine engine;
    private Boolean autocommit = true;
    private List<String> rInstructions = new LinkedList<String>();

    @Override
    public boolean init() {
        if (engine == null) {
            try {
                String[] args = new String[]{"--no-save"};
                System.setProperty("jri.ignore.ule", "yes");
                if (!Rengine.jriLoaded) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"Cannot find jri library, make sure it is correctly installed");
                    }
                    return false;
                }
                engine = new Rengine(args, false, null);
                if (!engine.waitForR()) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"Cannot load the R engine");
                    }
                    return false;
                }
            }
            catch (Exception eee) {
                this.log.error((Object)"An error occured during R/JNI initialization. Maybe you forgot to configure your environment");
                return false;
            }
        }
        return true;
    }

    @Override
    public Object eval(String expr) throws RException {
        String klass;
        REXP result;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("try(%s,silent=TRUE)", expr));
        }
        if ((result = engine.eval(String.format("try(%s,silent=TRUE)", expr))).getAttribute("class") != null && (klass = result.getAttribute("class").asString()).equals("try-error")) {
            throw new RException(result.asString());
        }
        return this.convertResult(result);
    }

    @Override
    public Object evalScript(String expr) throws RException {
        return this.eval("{" + expr + "}\n");
    }

    protected Object convertResult(REXP rexp) {
        if (rexp == null) {
            this.log.debug((Object)"Null returned");
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Converting : " + rexp.toString()));
        }
        int type = rexp.getType();
        Object result = null;
        switch (type) {
            case 3: {
                result = rexp.asString();
                break;
            }
            case 1: {
                result = rexp.asInt();
                break;
            }
            case 32: {
                int[] array = rexp.asIntArray();
                result = array;
                if (array.length != 1) break;
                result = array[0];
                break;
            }
            case 33: {
                double[] doubleArray = rexp.asDoubleArray();
                result = doubleArray;
                if (doubleArray.length != 1) break;
                result = doubleArray[0];
                break;
            }
            case 6: {
                result = rexp.asBool().isTRUE();
                break;
            }
            case 2: {
                result = rexp.asDoubleArray();
                result = ((double[])result)[0];
                break;
            }
            case 0: {
                result = null;
                break;
            }
            case 37: {
                result = rexp.asIntArray();
                int[] integers = (int[])result;
                Boolean[] booleanArray = new Boolean[integers.length];
                for (int i = 0; i < integers.length; ++i) {
                    booleanArray[i] = integers[i] == 1 ? Boolean.TRUE : Boolean.FALSE;
                }
                if (booleanArray.length == 1) {
                    result = booleanArray[0];
                    break;
                }
                result = booleanArray;
                break;
            }
            case 34: {
                result = rexp.asStringArray();
                break;
            }
            case 16: {
                String klass = "";
                REXP klassAttribute = rexp.getAttribute("class");
                if (klassAttribute != null) {
                    klass = klassAttribute.asString();
                }
                RList list = rexp.asList();
                if (klass.equals("data.frame")) {
                    result = this.convertToDataFrame(rexp);
                    break;
                }
                if (list != null) {
                    result = this.convertToRList(rexp);
                    break;
                }
                rexp.asVector();
                break;
            }
            default: {
                this.log.error((Object)("Unknown return type [" + type + "] " + "on : " + rexp.toString()));
            }
        }
        return result;
    }

    protected RDataFrame convertToDataFrame(REXP rexp) {
        RList list = rexp.asList();
        ArrayList data = new ArrayList();
        for (int i = 0; i < list.keys().length; ++i) {
            ArrayList<Object> templist = new ArrayList<Object>();
            REXP tempREXP = list.at(i);
            Object convertedREXP = this.convertResult(tempREXP);
            if (convertedREXP instanceof int[]) {
                for (int value : (int[])convertedREXP) {
                    templist.add(value);
                }
            }
            if (convertedREXP instanceof double[]) {
                for (double value : (double[])convertedREXP) {
                    templist.add(value);
                }
            }
            if (convertedREXP instanceof String[]) {
                templist.addAll(Arrays.asList((String[])convertedREXP));
            }
            if (convertedREXP instanceof Boolean[]) {
                templist.addAll(Arrays.asList((Boolean[])convertedREXP));
            }
            data.add(templist);
        }
        RDataFrame temp = new RDataFrame((REngine)this, rexp.getAttribute("names").asStringArray(), rexp.getAttribute("row.names").asStringArray(), data, "");
        return temp;
    }

    protected org.nuiton.j2r.types.RList convertToRList(REXP rexp) {
        org.nuiton.j2r.types.RList temp;
        block5: {
            temp = new org.nuiton.j2r.types.RList(this);
            ArrayList<Object> data = new ArrayList<Object>();
            REXP attrNames = rexp.getAttribute("names");
            String[] names = new String[]{};
            if (attrNames != null) {
                names = attrNames.asStringArray();
            }
            RList dataList = rexp.asList();
            Boolean flag = true;
            int index = 0;
            while (flag.booleanValue()) {
                REXP tempREXP = dataList.at(index);
                if (tempREXP == null) {
                    flag = false;
                    continue;
                }
                Object convertedREXP = this.convertResult(tempREXP);
                data.add(convertedREXP);
                ++index;
            }
            try {
                temp = new org.nuiton.j2r.types.RList(names, data, (REngine)this, "");
            }
            catch (RException re) {
                if (!this.log.isDebugEnabled()) break block5;
                this.log.debug((Object)"Converting REXP to RList. Creating list without variable name");
            }
        }
        return temp;
    }

    @Override
    public void terminate() {
        if (engine.isAlive()) {
            engine.end();
        }
    }

    @Override
    public void voidEval(String expr) throws RException {
        if (!this.autocommit.booleanValue()) {
            this.rInstructions.add(expr);
        } else {
            String classe;
            REXP r;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("try(%s,silent=TRUE)", expr));
            }
            if (null != (r = engine.eval(String.format("try(%s,silent=TRUE)", expr))) && null != r.getAttribute("class") && (classe = r.getAttribute("class").asString()).equals("try-error")) {
                throw new RException(r.asString());
            }
        }
    }

    @Override
    public void commit() throws RException {
        for (String expr : this.rInstructions) {
            engine.eval(expr);
        }
        this.rInstructions = new LinkedList<String>();
    }
}

