/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.j2r.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.types.REXP;
import org.nuiton.j2r.types.REXPAbstract;

public class RDataFrame
extends REXPAbstract
implements REXP {
    private Log log;
    private List<String> rowNames;
    private List<List<?>> data;

    public RDataFrame(REngine engine) {
        this.log = LogFactory.getLog(RDataFrame.class);
        this.names = new ArrayList();
        this.rowNames = new ArrayList<String>();
        this.data = new ArrayList();
        this.variable = "";
        this.engine = engine;
        this.attributes = new HashMap();
    }

    public RDataFrame(REngine engine, Object[] datatypes, int y) throws RException {
        this.log = LogFactory.getLog(RDataFrame.class);
        this.names = new ArrayList();
        this.rowNames = new ArrayList<String>();
        this.data = new ArrayList();
        for (int i = 0; i < datatypes.length; ++i) {
            this.checkType(datatypes[i]);
            ArrayList<Object> column = new ArrayList<Object>();
            for (int j = 0; j < y; ++j) {
                if (datatypes[i] instanceof Double) {
                    column.add(0.0);
                    continue;
                }
                if (datatypes[i] instanceof Integer) {
                    column.add(0);
                    continue;
                }
                if (datatypes[i] instanceof Boolean) {
                    column.add(true);
                    continue;
                }
                if (!(datatypes[i] instanceof String)) continue;
                column.add("");
            }
            this.data.add(column);
        }
        this.variable = "";
        this.engine = engine;
        this.attributes = new HashMap();
    }

    public RDataFrame(REngine engine, List<String> names, List<String> rowNames, List<List<?>> data, String variable) throws RException {
        this.log = LogFactory.getLog(RDataFrame.class);
        this.names = names;
        this.rowNames = rowNames;
        this.data = data;
        this.variable = variable;
        this.engine = engine;
        this.attributes = new HashMap();
        try {
            engine.eval(this.toRString());
        }
        catch (RException eee) {
            throw new RException("Cannot initialize data.frame in R", eee);
        }
    }

    public RDataFrame(REngine engine, String[] names, String[] rowNames, List<List<? extends Object>> data, String variable) {
        block6: {
            int i;
            this.log = LogFactory.getLog(RDataFrame.class);
            String[] tempNames = new String[]{};
            if (names != null) {
                tempNames = (String[])names.clone();
            }
            String[] tempRowNames = new String[]{};
            if (rowNames != null) {
                tempRowNames = (String[])rowNames.clone();
            }
            this.names = new ArrayList();
            for (i = 0; i < tempNames.length; ++i) {
                this.names.add(tempNames[i]);
            }
            this.rowNames = new ArrayList<String>();
            for (i = 0; i < tempRowNames.length; ++i) {
                this.rowNames.add(tempRowNames[i]);
            }
            this.data = data;
            this.variable = variable;
            this.engine = engine;
            this.attributes = new HashMap();
            try {
                engine.eval(this.toRString());
            }
            catch (RException eee) {
                if (!this.log.isDebugEnabled()) break block6;
                this.log.debug((Object)("Cannot initialize data.frame in R : " + eee.getMessage()));
            }
        }
    }

    public List<String> getRowNames() throws RException {
        if (this.engine.isAutoCommit().booleanValue()) {
            String[] rowNamesArray = (String[])this.engine.eval(String.format("row.names(%s)", this.variable));
            if (rowNamesArray.length <= this.data.get(0).size()) {
                this.rowNames.clear();
                for (int i = 0; i < rowNamesArray.length; ++i) {
                    this.rowNames.add(rowNamesArray[i]);
                }
                return this.rowNames;
            }
            throw new IndexOutOfBoundsException(String.format(this.dataInconsistencyText, rowNamesArray.length, this.data.get(0)));
        }
        return this.rowNames;
    }

    public String getRowName(int y) throws RException {
        if (y < this.rowNames.size()) {
            String name;
            if (this.engine.isAutoCommit().booleanValue() && (name = (String)this.engine.eval(String.format("row.names(%s)[%s]", this.variable, y + 1))) != null && !name.equals("")) {
                this.rowNames.set(y, name);
            }
        } else {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, y, this.rowNames.size()));
        }
        return this.rowNames.get(y);
    }

    public void setRowNames(List<String> rowNames) throws RException {
        String rowNamesString;
        if (rowNames.size() == this.data.get(0).size()) {
            this.rowNames = rowNames;
            rowNamesString = "";
            for (int i = 0; i < this.rowNames.size(); ++i) {
                if (i != 0) {
                    rowNamesString = rowNamesString + ",";
                }
                rowNamesString = rowNamesString + "\"" + rowNames.get(i) + "\"";
            }
        } else {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, rowNames.size(), this.data.get(0).size()));
        }
        String rexp = String.format("row.names(%s)<-c(%s)", this.variable, rowNamesString);
        this.engine.voidEval(rexp);
    }

    public void setRowName(int x, String rowName) throws RException {
        if (x >= this.rowNames.size()) {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, x, this.data.size()));
        }
        this.rowNames.set(x, rowName);
        String rexp = String.format("row.names(%s)[%s]<-\"%s\"", this.variable, x + 1, rowName);
        this.engine.voidEval(rexp);
    }

    @Override
    public String toRString() throws RException {
        int i;
        this.checkVariable();
        String returnString = this.variable + "<-data.frame(";
        if (!this.data.isEmpty()) {
            for (i = 0; i < this.data.size(); ++i) {
                int j;
                returnString = !this.names.isEmpty() ? returnString + (String)this.names.get(i) + "=c(" : returnString + "c(";
                if (this.data.get(i).get(0) instanceof String) {
                    for (j = 0; j < this.data.get(i).size(); ++j) {
                        returnString = returnString + "\"" + this.data.get(i).get(j) + "\",";
                    }
                } else if (this.data.get(i).get(0) instanceof Boolean) {
                    for (j = 0; j < this.data.get(i).size(); ++j) {
                        returnString = (Boolean)this.data.get(i).get(j) != false ? returnString + "TRUE," : returnString + "FALSE,";
                    }
                } else if (this.data.get(i).get(0) instanceof Integer) {
                    for (j = 0; j < this.data.get(i).size(); ++j) {
                        returnString = returnString + String.format("as.integer(%s)", this.data.get(i).get(j)) + ",";
                    }
                } else {
                    for (j = 0; j < this.data.get(i).size(); ++j) {
                        returnString = returnString + this.data.get(i).get(j) + ",";
                    }
                }
                returnString = returnString.substring(0, returnString.length() - 1);
                returnString = returnString + "),";
            }
        }
        if (!this.rowNames.isEmpty()) {
            returnString = returnString + "row.names=c(";
            for (i = 0; i < this.rowNames.size(); ++i) {
                returnString = returnString + "\"" + this.rowNames.get(i) + "\",";
            }
            returnString = returnString.substring(0, returnString.length() - 1) + "),stringsAsFactors=FALSE)";
        } else {
            returnString = this.data.isEmpty() ? returnString + ")" : returnString + "stringsAsFactors=FALSE)";
        }
        return returnString;
    }

    public void set(int x, int y, Object data) throws RException {
        block8: {
            this.checkVariable();
            this.checkX(x);
            this.checkY(y);
            try {
                if (this.data.get(x).get(y) instanceof Double) {
                    ((ArrayList)this.data.get(x)).set(y, (Double)data);
                    this.engine.voidEval(String.format("%s[%s,%s]<-%s", this.variable, y + 1, x + 1, data));
                    break block8;
                }
                if (this.data.get(x).get(y) instanceof Boolean) {
                    ((ArrayList)this.data.get(x)).set(y, (Boolean)data);
                    if (((Boolean)data).booleanValue()) {
                        this.engine.voidEval(String.format("%s[%s,%s]<-%s", this.variable, y + 1, x + 1, "TRUE"));
                    } else {
                        this.engine.voidEval(String.format("%s[%s,%s]<-%s", this.variable, y + 1, x + 1, "FALSE"));
                    }
                    break block8;
                }
                if (this.data.get(x).get(y) instanceof String) {
                    ((ArrayList)this.data.get(x)).set(y, (String)data);
                    this.engine.voidEval(String.format("%s[%s,%s]<-%s", this.variable, y + 1, x + 1, "\"" + data + "\""));
                    break block8;
                }
                if (this.data.get(x).get(y) instanceof Integer) {
                    ((ArrayList)this.data.get(x)).set(y, (Integer)data);
                    this.engine.voidEval(String.format("%s[%s,%s]<-%s", this.variable, y + 1, x + 1, String.format("as.integer(%s)", data)));
                    break block8;
                }
                throw new ArrayStoreException("The data.frame does not accept this type on those coordinates : " + data.getClass());
            }
            catch (ClassCastException cce) {
                throw new RException("The data.frame does not accept this type on those coordinates : " + data.getClass(), cce);
            }
        }
    }

    public Object get(int x, int y) throws RException {
        this.checkX(x);
        this.checkY(y);
        if (this.engine.isAutoCommit().booleanValue() && this.variable != null && !this.variable.isEmpty()) {
            Object returnObject = this.engine.eval(String.format("%s[%s,%s]", this.variable, y + 1, x + 1));
            if (returnObject instanceof String) {
                ((ArrayList)this.data.get(x)).set(y, (String)returnObject);
            } else if (returnObject instanceof Double) {
                ((ArrayList)this.data.get(x)).set(y, (Double)returnObject);
            } else if (returnObject instanceof Integer) {
                ((ArrayList)this.data.get(x)).set(y, (Integer)returnObject);
            } else if (returnObject instanceof Boolean) {
                ((ArrayList)this.data.get(x)).set(y, (Boolean)returnObject);
            }
        }
        return this.data.get(x).get(y);
    }

    public List<List<? extends Object>> getData() {
        return this.data;
    }

    public void setData(List<List<? extends Object>> data) throws RException {
        this.data = data;
        this.engine.voidEval(this.toRString());
    }

    @Override
    public void getFrom(String variable) throws RException {
        this.variable = variable;
        if (this.engine.isAutoCommit().booleanValue()) {
            if (this.rowNames != null) {
                this.rowNames.clear();
            } else {
                this.rowNames = new ArrayList<String>();
            }
            if (this.names != null) {
                this.names.clear();
            } else {
                this.names = new ArrayList();
            }
            if (this.data != null) {
                this.data.clear();
            } else {
                this.data = new ArrayList();
            }
            if (this.attributes != null) {
                this.attributes.clear();
            } else {
                this.attributes = new HashMap();
            }
            String[] rowNamesArray = (String[])this.engine.eval(String.format("row.names(%s)", this.variable));
            for (int i = 0; i < rowNamesArray.length; ++i) {
                this.rowNames.add(rowNamesArray[i]);
            }
            String[] namesArray = (String[])this.engine.eval(String.format("names(%s)", this.variable));
            for (int i = 0; i < namesArray.length; ++i) {
                this.names.add(namesArray[i]);
            }
            Integer dataframelength = (Integer)this.engine.eval(String.format("length(%s)", this.variable));
            for (int i = 0; i < dataframelength; ++i) {
                Integer arrayListLength = (Integer)this.engine.eval(String.format("length(%s[,%s])", this.variable, i + 1));
                ArrayList<Serializable> thisColumn = new ArrayList<Serializable>();
                for (int j = 0; j < arrayListLength; ++j) {
                    thisColumn.add((Serializable)this.engine.eval(String.format("%s[%s,%s]", this.variable, j + 1, i + 1)));
                }
                this.data.add(thisColumn);
            }
            Integer attributeslength = (Integer)this.engine.eval(String.format("length(attributes(%s))", this.variable));
            for (int i = 0; i < attributeslength; ++i) {
                String key = (String)this.engine.eval(String.format("names(attributes(%s))[%s]", this.variable, i + 1));
                String attribute = (String)this.engine.eval("toString(" + String.format("attr(%s,\"%s\")", this.variable, key) + ")");
                this.attributes.put(key, attribute);
            }
        }
    }

    public void exportCsv(File outputFile, boolean rowNames, boolean names) throws IOException {
        int i;
        BufferedWriter file = new BufferedWriter(new FileWriter(outputFile));
        if (names) {
            if (rowNames) {
                file.write(";");
            }
            for (i = 0; i < this.names.size(); ++i) {
                file.write((String)this.names.get(i) + ";");
            }
            file.newLine();
        }
        for (i = 0; i < this.data.get(0).size(); ++i) {
            if (rowNames) {
                file.write(this.rowNames.get(i) + ";");
            }
            for (int j = 0; j < this.data.size(); ++j) {
                file.write(this.data.get(j).get(i) + ";");
            }
            file.newLine();
        }
        file.close();
    }

    public void importCsv(File inputFile, boolean rowNames, boolean names) throws FileNotFoundException, IOException {
        ArrayList<Object> tmp = new ArrayList<Object>();
        tmp.add("string");
        this.importCsv(inputFile, rowNames, names, tmp);
    }

    public void importCsv(File inputFile, boolean rowNames, boolean names, Object importType) throws FileNotFoundException, IOException {
        ArrayList<Object> tmp = new ArrayList<Object>();
        if (importType instanceof String) {
            tmp.add((String)importType);
            this.importCsv(inputFile, rowNames, names, tmp);
        } else if (importType instanceof Double) {
            tmp.add((Double)importType);
            this.importCsv(inputFile, rowNames, names, tmp);
        } else if (importType instanceof Integer) {
            tmp.add((Integer)importType);
            this.importCsv(inputFile, rowNames, names, tmp);
        }
    }

    public void importCsv(File inputFile, boolean rowNames, boolean names, List<Object> importTypes) throws FileNotFoundException, IOException {
        Integer dataSize = 0;
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        String tmp = br.readLine();
        String[] splitted = tmp.split("\\;");
        dataSize = rowNames ? Integer.valueOf(splitted.length - 1) : Integer.valueOf(splitted.length);
        if (this.data != null) {
            this.data.clear();
        }
        if (rowNames && this.rowNames != null) {
            this.rowNames.clear();
        }
        if (names) {
            if (this.names != null) {
                this.names.clear();
            }
            for (int i = 1; i < splitted.length; ++i) {
                this.names.add(splitted[i]);
            }
        }
        ArrayList tempData = new ArrayList();
        for (int i = 0; i < dataSize; ++i) {
            ArrayList column = new ArrayList();
            tempData.add(column);
        }
        while ((tmp = br.readLine()) != null) {
            splitted = tmp.split("\\;");
            int index = 0;
            if (rowNames) {
                this.rowNames.add(splitted[0]);
                index = 1;
            }
            for (int i = 0 + index; i < splitted.length; ++i) {
                if (importTypes.size() == 1) {
                    if (importTypes.get(0) instanceof String) {
                        ((ArrayList)tempData.get(i - index)).add(splitted[i]);
                        continue;
                    }
                    if (importTypes.get(0) instanceof Double) {
                        ((ArrayList)tempData.get(i - index)).add(Double.valueOf(splitted[i]));
                        continue;
                    }
                    if (!(importTypes.get(0) instanceof Integer)) continue;
                    ((ArrayList)tempData.get(i - index)).add(Integer.valueOf(splitted[i]));
                    continue;
                }
                if (importTypes.get(i - index) instanceof String) {
                    ((ArrayList)tempData.get(i - index)).add(splitted[i]);
                    continue;
                }
                if (importTypes.get(i - index) instanceof Double) {
                    ((ArrayList)tempData.get(i - index)).add(Double.valueOf(splitted[i]));
                    continue;
                }
                if (!(importTypes.get(i - index) instanceof Integer)) continue;
                ((ArrayList)tempData.get(i - index)).add(Integer.valueOf(splitted[i]));
            }
        }
        br.close();
        this.data = tempData;
    }

    private void checkY(int y) {
        if (!this.data.get(0).isEmpty() && y > this.data.get(0).size()) {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, y, this.data.size()));
        }
    }

    @Override
    public void checkX(int x) {
        if (x > this.data.size() && !this.data.isEmpty()) {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, x, this.data.size()));
        }
    }

    private void checkType(Object o) throws RException {
        if (!(o instanceof String || o instanceof Double || o instanceof Integer || o instanceof Boolean)) {
            throw new RException("Not supported type");
        }
    }

    public int[] dim() throws RException {
        int x = (Integer)this.engine.eval("dim(" + this.variable + ")[1]");
        int y = (Integer)this.engine.eval("dim(" + this.variable + ")[2]");
        return new int[]{x, y};
    }
}

