/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.db.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.nuiton.db.meta.ArgumentMeta;
import org.nuiton.db.meta.ProcedureMeta;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ProcedureMeta", generator="Immutables")
@Immutable
public final class ImmutableProcedureMeta
implements ProcedureMeta {
    private final String name;
    private final ImmutableList<ArgumentMeta> args;
    @Nullable
    private final String comment;

    private ImmutableProcedureMeta(String name, ImmutableList<ArgumentMeta> args, @Nullable String comment) {
        this.name = name;
        this.args = args;
        this.comment = comment;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<ArgumentMeta> getArgs() {
        return this.args;
    }

    @Override
    public Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public final ImmutableProcedureMeta withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableProcedureMeta(newValue, this.args, this.comment);
    }

    public final ImmutableProcedureMeta withArgs(ArgumentMeta ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableProcedureMeta(this.name, (ImmutableList<ArgumentMeta>)newValue, this.comment);
    }

    public final ImmutableProcedureMeta withArgs(Iterable<? extends ArgumentMeta> elements) {
        if (this.args == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableProcedureMeta(this.name, (ImmutableList<ArgumentMeta>)newValue, this.comment);
    }

    public final ImmutableProcedureMeta withComment(String value) {
        String newValue = Objects.requireNonNull(value, "comment");
        if (Objects.equals(this.comment, newValue)) {
            return this;
        }
        return new ImmutableProcedureMeta(this.name, this.args, newValue);
    }

    public final ImmutableProcedureMeta withComment(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.comment, value)) {
            return this;
        }
        return new ImmutableProcedureMeta(this.name, this.args, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcedureMeta && this.equalTo((ImmutableProcedureMeta)another);
    }

    private boolean equalTo(ImmutableProcedureMeta another) {
        return this.name.equals(another.name) && this.args.equals(another.args) && Objects.equals(this.comment, another.comment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.args.hashCode();
        h += (h << 5) + Objects.hashCode(this.comment);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ProcedureMeta").omitNullValues().add("name", (Object)this.name).add("args", this.args).add("comment", (Object)this.comment).toString();
    }

    public static ImmutableProcedureMeta copyOf(ProcedureMeta instance) {
        if (instance instanceof ImmutableProcedureMeta) {
            return (ImmutableProcedureMeta)instance;
        }
        return ImmutableProcedureMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProcedureMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        private ImmutableList.Builder<ArgumentMeta> args = ImmutableList.builder();
        @Nullable
        private String comment;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ProcedureMeta instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.addAllArgs(instance.getArgs());
            Optional<String> commentOptional = instance.getComment();
            if (commentOptional.isPresent()) {
                this.comment(commentOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArgs(ArgumentMeta element) {
            this.args.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArgs(ArgumentMeta ... elements) {
            this.args.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder args(Iterable<? extends ArgumentMeta> elements) {
            this.args = ImmutableList.builder();
            return this.addAllArgs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArgs(Iterable<? extends ArgumentMeta> elements) {
            this.args.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "comment");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder comment(Optional<String> comment) {
            this.comment = comment.orElse(null);
            return this;
        }

        public ImmutableProcedureMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProcedureMeta(this.name, this.args.build(), this.comment);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ProcedureMeta, some of required attributes are not set " + attributes;
        }
    }
}

