/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.db.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.nuiton.db.meta.CustomTypeMeta;
import org.nuiton.db.meta.DatabaseMeta;
import org.nuiton.db.meta.ProcedureMeta;
import org.nuiton.db.meta.TableMeta;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DatabaseMeta", generator="Immutables")
@Immutable
public final class ImmutableDatabaseMeta
implements DatabaseMeta {
    private final String schema;
    private final ImmutableList<CustomTypeMeta> customTypes;
    private final ImmutableList<TableMeta> tables;
    private final ImmutableList<TableMeta> views;
    private final ImmutableList<ProcedureMeta> procedures;

    private ImmutableDatabaseMeta(String schema, ImmutableList<CustomTypeMeta> customTypes, ImmutableList<TableMeta> tables, ImmutableList<TableMeta> views, ImmutableList<ProcedureMeta> procedures) {
        this.schema = schema;
        this.customTypes = customTypes;
        this.tables = tables;
        this.views = views;
        this.procedures = procedures;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public ImmutableList<CustomTypeMeta> getCustomTypes() {
        return this.customTypes;
    }

    @Override
    public ImmutableList<TableMeta> getTables() {
        return this.tables;
    }

    @Override
    public ImmutableList<TableMeta> getViews() {
        return this.views;
    }

    @Override
    public ImmutableList<ProcedureMeta> getProcedures() {
        return this.procedures;
    }

    public final ImmutableDatabaseMeta withSchema(String value) {
        String newValue = Objects.requireNonNull(value, "schema");
        if (this.schema.equals(newValue)) {
            return this;
        }
        return new ImmutableDatabaseMeta(newValue, this.customTypes, this.tables, this.views, this.procedures);
    }

    public final ImmutableDatabaseMeta withCustomTypes(CustomTypeMeta ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDatabaseMeta(this.schema, (ImmutableList<CustomTypeMeta>)newValue, this.tables, this.views, this.procedures);
    }

    public final ImmutableDatabaseMeta withCustomTypes(Iterable<? extends CustomTypeMeta> elements) {
        if (this.customTypes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDatabaseMeta(this.schema, (ImmutableList<CustomTypeMeta>)newValue, this.tables, this.views, this.procedures);
    }

    public final ImmutableDatabaseMeta withTables(TableMeta ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDatabaseMeta(this.schema, this.customTypes, (ImmutableList<TableMeta>)newValue, this.views, this.procedures);
    }

    public final ImmutableDatabaseMeta withTables(Iterable<? extends TableMeta> elements) {
        if (this.tables == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDatabaseMeta(this.schema, this.customTypes, (ImmutableList<TableMeta>)newValue, this.views, this.procedures);
    }

    public final ImmutableDatabaseMeta withViews(TableMeta ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDatabaseMeta(this.schema, this.customTypes, this.tables, (ImmutableList<TableMeta>)newValue, this.procedures);
    }

    public final ImmutableDatabaseMeta withViews(Iterable<? extends TableMeta> elements) {
        if (this.views == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDatabaseMeta(this.schema, this.customTypes, this.tables, (ImmutableList<TableMeta>)newValue, this.procedures);
    }

    public final ImmutableDatabaseMeta withProcedures(ProcedureMeta ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDatabaseMeta(this.schema, this.customTypes, this.tables, this.views, (ImmutableList<ProcedureMeta>)newValue);
    }

    public final ImmutableDatabaseMeta withProcedures(Iterable<? extends ProcedureMeta> elements) {
        if (this.procedures == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDatabaseMeta(this.schema, this.customTypes, this.tables, this.views, (ImmutableList<ProcedureMeta>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDatabaseMeta && this.equalTo((ImmutableDatabaseMeta)another);
    }

    private boolean equalTo(ImmutableDatabaseMeta another) {
        return this.schema.equals(another.schema) && this.customTypes.equals(another.customTypes) && this.tables.equals(another.tables) && this.views.equals(another.views) && this.procedures.equals(another.procedures);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.schema.hashCode();
        h += (h << 5) + this.customTypes.hashCode();
        h += (h << 5) + this.tables.hashCode();
        h += (h << 5) + this.views.hashCode();
        h += (h << 5) + this.procedures.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DatabaseMeta").omitNullValues().add("schema", (Object)this.schema).add("customTypes", this.customTypes).add("tables", this.tables).add("views", this.views).add("procedures", this.procedures).toString();
    }

    public static ImmutableDatabaseMeta copyOf(DatabaseMeta instance) {
        if (instance instanceof ImmutableDatabaseMeta) {
            return (ImmutableDatabaseMeta)instance;
        }
        return ImmutableDatabaseMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DatabaseMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SCHEMA = 1L;
        private long initBits = 1L;
        @Nullable
        private String schema;
        private ImmutableList.Builder<CustomTypeMeta> customTypes = ImmutableList.builder();
        private ImmutableList.Builder<TableMeta> tables = ImmutableList.builder();
        private ImmutableList.Builder<TableMeta> views = ImmutableList.builder();
        private ImmutableList.Builder<ProcedureMeta> procedures = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DatabaseMeta instance) {
            Objects.requireNonNull(instance, "instance");
            this.schema(instance.getSchema());
            this.addAllCustomTypes((Iterable<? extends CustomTypeMeta>)instance.getCustomTypes());
            this.addAllTables((Iterable<? extends TableMeta>)instance.getTables());
            this.addAllViews((Iterable<? extends TableMeta>)instance.getViews());
            this.addAllProcedures((Iterable<? extends ProcedureMeta>)instance.getProcedures());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schema(String schema) {
            this.schema = Objects.requireNonNull(schema, "schema");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCustomTypes(CustomTypeMeta element) {
            this.customTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCustomTypes(CustomTypeMeta ... elements) {
            this.customTypes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder customTypes(Iterable<? extends CustomTypeMeta> elements) {
            this.customTypes = ImmutableList.builder();
            return this.addAllCustomTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCustomTypes(Iterable<? extends CustomTypeMeta> elements) {
            this.customTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTables(TableMeta element) {
            this.tables.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTables(TableMeta ... elements) {
            this.tables.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tables(Iterable<? extends TableMeta> elements) {
            this.tables = ImmutableList.builder();
            return this.addAllTables(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTables(Iterable<? extends TableMeta> elements) {
            this.tables.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addViews(TableMeta element) {
            this.views.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addViews(TableMeta ... elements) {
            this.views.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder views(Iterable<? extends TableMeta> elements) {
            this.views = ImmutableList.builder();
            return this.addAllViews(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllViews(Iterable<? extends TableMeta> elements) {
            this.views.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProcedures(ProcedureMeta element) {
            this.procedures.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProcedures(ProcedureMeta ... elements) {
            this.procedures.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder procedures(Iterable<? extends ProcedureMeta> elements) {
            this.procedures = ImmutableList.builder();
            return this.addAllProcedures(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllProcedures(Iterable<? extends ProcedureMeta> elements) {
            this.procedures.addAll(elements);
            return this;
        }

        public ImmutableDatabaseMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDatabaseMeta(this.schema, this.customTypes.build(), this.tables.build(), this.views.build(), this.procedures.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("schema");
            }
            return "Cannot build DatabaseMeta, some of required attributes are not set " + attributes;
        }
    }
}

