/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.db.meta;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.nuiton.db.meta.ColumnRef;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ColumnRef", generator="Immutables")
@Immutable
public final class ImmutableColumnRef
implements ColumnRef {
    private final String table;
    @Nullable
    private final String column;

    private ImmutableColumnRef(String table, @Nullable String column) {
        this.table = table;
        this.column = column;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public Optional<String> getColumn() {
        return Optional.ofNullable(this.column);
    }

    public final ImmutableColumnRef withTable(String value) {
        String newValue = Objects.requireNonNull(value, "table");
        if (this.table.equals(newValue)) {
            return this;
        }
        return new ImmutableColumnRef(newValue, this.column);
    }

    public final ImmutableColumnRef withColumn(String value) {
        String newValue = Objects.requireNonNull(value, "column");
        if (Objects.equals(this.column, newValue)) {
            return this;
        }
        return new ImmutableColumnRef(this.table, newValue);
    }

    public final ImmutableColumnRef withColumn(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.column, value)) {
            return this;
        }
        return new ImmutableColumnRef(this.table, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableColumnRef && this.equalTo((ImmutableColumnRef)another);
    }

    private boolean equalTo(ImmutableColumnRef another) {
        return this.table.equals(another.table) && Objects.equals(this.column, another.column);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.table.hashCode();
        h += (h << 5) + Objects.hashCode(this.column);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ColumnRef").omitNullValues().add("table", (Object)this.table).add("column", (Object)this.column).toString();
    }

    public static ImmutableColumnRef copyOf(ColumnRef instance) {
        if (instance instanceof ImmutableColumnRef) {
            return (ImmutableColumnRef)instance;
        }
        return ImmutableColumnRef.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ColumnRef", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TABLE = 1L;
        private long initBits = 1L;
        @Nullable
        private String table;
        @Nullable
        private String column;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ColumnRef instance) {
            Objects.requireNonNull(instance, "instance");
            this.table(instance.getTable());
            Optional<String> columnOptional = instance.getColumn();
            if (columnOptional.isPresent()) {
                this.column(columnOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder table(String table) {
            this.table = Objects.requireNonNull(table, "table");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder column(String column) {
            this.column = Objects.requireNonNull(column, "column");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder column(Optional<String> column) {
            this.column = column.orElse(null);
            return this;
        }

        public ImmutableColumnRef build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableColumnRef(this.table, this.column);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("table");
            }
            return "Cannot build ColumnRef, some of required attributes are not set " + attributes;
        }
    }
}

