/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.db.meta;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.nuiton.db.meta.ArgumentMeta;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ArgumentMeta", generator="Immutables")
@Immutable
public final class ImmutableArgumentMeta
implements ArgumentMeta {
    private final String type;
    @Nullable
    private final String name;

    private ImmutableArgumentMeta(String type, @Nullable String name) {
        this.type = type;
        this.name = name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public final ImmutableArgumentMeta withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableArgumentMeta(newValue, this.name);
    }

    public final ImmutableArgumentMeta withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new ImmutableArgumentMeta(this.type, newValue);
    }

    public final ImmutableArgumentMeta withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableArgumentMeta(this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableArgumentMeta && this.equalTo((ImmutableArgumentMeta)another);
    }

    private boolean equalTo(ImmutableArgumentMeta another) {
        return this.type.equals(another.type) && Objects.equals(this.name, another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.name);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ArgumentMeta").omitNullValues().add("type", (Object)this.type).add("name", (Object)this.name).toString();
    }

    public static ImmutableArgumentMeta copyOf(ArgumentMeta instance) {
        if (instance instanceof ImmutableArgumentMeta) {
            return (ImmutableArgumentMeta)instance;
        }
        return ImmutableArgumentMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ArgumentMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String type;
        @Nullable
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ArgumentMeta instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            Optional<String> nameOptional = instance.getName();
            if (nameOptional.isPresent()) {
                this.name(nameOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public ImmutableArgumentMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableArgumentMeta(this.type, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ArgumentMeta, some of required attributes are not set " + attributes;
        }
    }
}

