/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.db.meta;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.db.meta.ColumnRef;
import org.nuiton.db.meta.CustomTypeMeta;
import org.nuiton.db.meta.DatabaseMeta;
import org.nuiton.db.meta.ImmutableArgumentMeta;
import org.nuiton.db.meta.ImmutableColumnMeta;
import org.nuiton.db.meta.ImmutableCustomTypeMeta;
import org.nuiton.db.meta.ImmutableDatabaseMeta;
import org.nuiton.db.meta.ImmutableProcedureMeta;
import org.nuiton.db.meta.ImmutableTableMeta;
import org.nuiton.db.meta.ProcedureMeta;
import org.nuiton.db.meta.SqlWork;
import org.nuiton.db.meta.TableMeta;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class DatabaseMetaBuilder {
    private static final Log log = LogFactory.getLog(DatabaseMetaBuilder.class);
    public static final Pattern POSSIBLE_VALUES_PATTERN = Pattern.compile("(Valeurs possibles :){1} (.*)");
    protected static Cache<String, Long> metaCountCache;
    protected final Consumer<SqlWork> worker;
    protected final String packageForEnumResolver;

    public DatabaseMetaBuilder(Consumer<SqlWork> worker, String packageForEnumResolver) {
        this.worker = worker;
        this.packageForEnumResolver = packageForEnumResolver;
    }

    public DatabaseMetaBuilder(Connection sqlConnection, String packageForEnumResolver) {
        this((SqlWork sqlWork) -> {
            try {
                sqlWork.execute(sqlConnection);
            }
            catch (SQLException e) {
                log.error((Object)"Unable to do SqlWork", (Throwable)e);
            }
        }, packageForEnumResolver);
    }

    public DatabaseMetaBuilder(Connection sqlConnection) {
        this(sqlConnection, null);
    }

    protected Cache<String, Long> getMetaCountCache() {
        if (metaCountCache == null) {
            metaCountCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
        }
        return metaCountCache;
    }

    protected void doWork(SqlWork work) {
        this.worker.accept(work);
    }

    protected ImmutableSet<String> getTableNames(String schema, String type) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.doWork(connection -> {
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getTables(null, schema, null, new String[]{type});){
                while (resultSet.next()) {
                    String name = resultSet.getString("TABLE_NAME");
                    builder.add((Object)name);
                }
            }
        });
        return builder.build();
    }

    protected ImmutableSet<String> getColumnNames(String schema, String tableName) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.doWork(connection -> {
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getColumns(null, schema, tableName, null);){
                while (resultSet.next()) {
                    String name = resultSet.getString("COLUMN_NAME");
                    builder.add((Object)name);
                }
            }
        });
        return builder.build();
    }

    protected ImmutableList<TableMeta> readTableMetas(String type, String schema, Map<ColumnRef, String> comments, Set<ColumnRef> primaryKeys, Set<ColumnRef> uniqueColumns, Multimap<ColumnRef, ColumnRef> foreignKeys, ImmutableList<CustomTypeMeta> customTypes) {
        ImmutableList.Builder tableMetas = ImmutableList.builder();
        for (String tableName : this.getTableNames(schema, type)) {
            ImmutableSet<String> columnNames = this.getColumnNames(schema, tableName);
            this.doWork(connection -> {
                ColumnRef commentKey;
                Optional<String> comment;
                Object resultSet;
                ArrayList columns = Lists.newArrayList();
                for (String tableColumnName : columnNames) {
                    DatabaseMetaData metaData = connection.getMetaData();
                    resultSet = metaData.getColumns(null, schema, tableName, tableColumnName);
                    Throwable throwable = null;
                    try {
                        while (resultSet.next()) {
                            String dataType = resultSet.getString("TYPE_NAME");
                            Optional<Integer> size = Optional.empty();
                            Optional<CustomTypeMeta> customTypeMeta = customTypes.stream().filter(customType -> customType.getName().equals(dataType)).findAny();
                            if (!customTypeMeta.isPresent()) {
                                size = Optional.of(resultSet.getInt("COLUMN_SIZE"));
                            }
                            boolean nullable = resultSet.getInt("NULLABLE") == 1;
                            ColumnRef columnRef = this.asCommentKey(tableName, tableColumnName);
                            Optional<String> comment2 = Optional.ofNullable(comments.get(columnRef));
                            boolean primaryKey = primaryKeys.contains(columnRef);
                            boolean unique = uniqueColumns.contains(columnRef);
                            if (!comment2.isPresent() && log.isWarnEnabled()) {
                                log.warn((Object)String.format("Pas de commentaire pour la colonne %s", columnRef.pretty()));
                            }
                            ImmutableSet<String> keys = this.getForeignKeys(foreignKeys, columnRef);
                            Optional<Object> possibleValues = Optional.empty();
                            if (comment2.isPresent()) {
                                Matcher matcher = POSSIBLE_VALUES_PATTERN.matcher((CharSequence)comment2.get());
                                if (matcher.find()) {
                                    Map map;
                                    String values = matcher.group(2);
                                    if (values.contains("=")) {
                                        map = Splitter.on((String)",").omitEmptyStrings().trimResults().withKeyValueSeparator("=").split((CharSequence)values);
                                        if (log.isWarnEnabled()) {
                                            for (Map.Entry entry : map.entrySet()) {
                                                if (!((String)entry.getKey()).equals(entry.getValue())) continue;
                                                String message = String.format("Valeur '%s' suspecte (identique cl\u00e9=valeur) pour la colonne %s", entry.getKey(), columnRef.pretty());
                                                log.warn((Object)message);
                                            }
                                        }
                                    } else {
                                        Iterable tabPossibleValues = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)values);
                                        map = Maps.newHashMap();
                                        for (String possibleValue : tabPossibleValues) {
                                            map.put(possibleValue, null);
                                        }
                                    }
                                    possibleValues = Optional.of(map);
                                }
                                if (customTypeMeta.isPresent() && log.isWarnEnabled()) {
                                    if (possibleValues.isPresent()) {
                                        for (String value : ((Map)possibleValues.get()).keySet()) {
                                            if (customTypeMeta.get().getValues().contains((Object)value)) continue;
                                            String message = String.format("La valeur '%s' n'est pas attendue selon le type %s pour la colonne %s", value, customTypeMeta.get().getName(), columnRef.pretty());
                                            log.warn((Object)message);
                                        }
                                    } else {
                                        String message = String.format("La liste des valeurs n'est pas d\u00e9taill\u00e9e pour la colonne %s de type %s", columnRef.pretty(), customTypeMeta.get().getName());
                                        log.warn((Object)message);
                                    }
                                }
                            }
                            ImmutableColumnMeta column = ImmutableColumnMeta.builder().name(tableColumnName).type(dataType).customType(customTypeMeta).length(size).nullable(nullable).comment(comment2).isPrimaryKey(primaryKey).isUnique(unique).isForeignKey(!keys.isEmpty()).foreignKeyColumns((Iterable<String>)keys).possibleValues(possibleValues).build();
                            columns.add(column);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (resultSet == null) continue;
                        if (throwable != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        resultSet.close();
                    }
                }
                Long count = (Long)this.getMetaCountCache().getIfPresent((Object)tableName);
                if (count == null && !"VIEW".equals(type)) {
                    String sql = String.format(" SELECT COUNT(*) FROM %s.%s ", schema, tableName);
                    PreparedStatement statement = connection.prepareStatement(sql);
                    resultSet = null;
                    try {
                        try (ResultSet countResultSet = statement.executeQuery();){
                            if (countResultSet.next()) {
                                count = countResultSet.getLong(1);
                            }
                        }
                        this.getMetaCountCache().put((Object)tableName, (Object)count);
                    }
                    catch (Throwable throwable) {
                        resultSet = throwable;
                        throw throwable;
                    }
                    finally {
                        if (statement != null) {
                            if (resultSet != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)resultSet).addSuppressed(throwable);
                                }
                            } else {
                                statement.close();
                            }
                        }
                    }
                }
                if (!(comment = Optional.ofNullable(comments.get(commentKey = this.asCommentKey(tableName, null)))).isPresent() && log.isWarnEnabled()) {
                    log.warn((Object)String.format("Pas de commentaire pour la table/vue %s", tableName));
                }
                ImmutableTableMeta tableMeta = ImmutableTableMeta.builder().name(tableName).isView("VIEW".equals(type)).columns(columns).count(Optional.ofNullable(count)).comment(comment).build();
                tableMetas.add((Object)tableMeta);
            });
        }
        ImmutableList result = tableMetas.build();
        return result;
    }

    protected ImmutableSet<String> getForeignKeys(Multimap<ColumnRef, ColumnRef> foreignKeys, ColumnRef columnRef) {
        Collection keys = foreignKeys.get((Object)columnRef);
        if (CollectionUtils.isEmpty((Collection)keys)) {
            return ImmutableSet.of();
        }
        ImmutableSet result = (ImmutableSet)keys.stream().map(ColumnRef::pretty).collect(ImmutableSet.toImmutableSet());
        return result;
    }

    protected ColumnRef asCommentKey(String tableName, String columnName) {
        Optional<String> right = Optional.ofNullable(StringUtils.trimToNull((String)columnName));
        if (right.isPresent()) {
            return ColumnRef.forColumn(tableName, columnName);
        }
        return ColumnRef.forTable(tableName);
    }

    protected ColumnRef asProcedureKey(String procedureName, String argTypesString) {
        Optional<String> args = Optional.ofNullable(StringUtils.trimToNull((String)argTypesString));
        String procedureKey = procedureName;
        if (args.isPresent()) {
            procedureKey = procedureKey + String.format(" (%s)", args.get());
        }
        ColumnRef procedureRef = this.asCommentKey(procedureKey, null);
        return procedureRef;
    }

    protected Map<ColumnRef, String> readTableAndViewComments(String schema) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.doWork(connection -> {
            String sql = String.format("SELECT     t.table_type AS table_type,     t.table_name AS table,     c.column_name AS colonne,     d.description AS commentaire FROM (         SELECT             table_schema,             table_name,             (table_schema || '.' || table_name)::regclass::oid AS objoid,             table_type         FROM             information_schema.tables         WHERE             table_schema = '%s') t     INNER JOIN pg_catalog.pg_description d          ON d.objoid = t.objoid     LEFT JOIN information_schema.columns c          ON c.table_schema = t.table_schema         AND c.table_name = t.table_name         AND c.ordinal_position = d.objsubid     ORDER BY         t.table_name,         d.objsubid; ", schema);
            try (PreparedStatement statement = connection.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String table = resultSet.getString("table");
                    String colonne = resultSet.getString("colonne");
                    String commentaire = resultSet.getString("commentaire");
                    ColumnRef key = this.asCommentKey(table, colonne);
                    builder.put((Object)key, (Object)commentaire);
                }
            }
        });
        ImmutableMap result = builder.build();
        return result;
    }

    protected Map<ColumnRef, String> readProcedureComments(String schema) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.doWork(connection -> {
            String sql = String.format("SELECT    p.proname AS nom,     p.proargtypes AS arguments,     d.description AS commentaire FROM     pg_catalog.pg_namespace n     JOIN pg_catalog.pg_proc p ON p.pronamespace = n.oid     INNER JOIN pg_catalog.pg_description d ON d.objoid = p.oid WHERE     n.nspname = '%s'  ; ", schema);
            try (PreparedStatement statement = connection.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String table = resultSet.getString("nom");
                    String argTypesString = resultSet.getString("arguments");
                    String commentaire = resultSet.getString("commentaire");
                    ColumnRef key = this.asProcedureKey(table, argTypesString);
                    builder.put((Object)key, (Object)commentaire);
                }
            }
        });
        ImmutableMap result = builder.build();
        return result;
    }

    protected ImmutableList<ProcedureMeta> readProcedureMetas(String schema) {
        Map<ColumnRef, String> comments = this.readProcedureComments(schema);
        ImmutableList.Builder builder = ImmutableList.builder();
        HashMap types = new HashMap();
        this.doWork(connection -> {
            String sql = " select oid, t.typname from pg_type t ";
            try (PreparedStatement statement = connection.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    int id = resultSet.getInt("oid");
                    String type = resultSet.getString("typname");
                    types.put(id, type);
                }
            }
        });
        this.doWork(connection -> {
            String sql = String.format("select p.proname, p.proargnames, p.proargtypes  from pg_proc p  inner join pg_namespace n    on n.oid = p.pronamespace  where  (p.proowner > 10 or p.proowner = (select usesysid FROM pg_user u where u.usename = (select * from current_user)))  and n.nspname='%s'", schema);
            try (PreparedStatement statement = connection.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String name = resultSet.getString("proname");
                    String argTypesString = resultSet.getString("proargtypes");
                    LinkedList<ImmutableArgumentMeta> args = new LinkedList<ImmutableArgumentMeta>();
                    if (StringUtils.isNotEmpty((CharSequence)argTypesString)) {
                        ImmutableList argTypes = (ImmutableList)Streams.stream((Iterable)Splitter.on((char)' ').split((CharSequence)argTypesString)).map(Integer::valueOf).map(types::get).collect(ImmutableList.toImmutableList());
                        String proArgs = Strings.nullToEmpty((String)resultSet.getString("proargnames"));
                        if (proArgs.startsWith("{") && proArgs.endsWith("}")) {
                            proArgs = proArgs.substring(0, proArgs.length() - 1).substring(1);
                        }
                        ImmutableList argNames = ImmutableList.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().split((CharSequence)proArgs));
                        for (int i = 0; i < argTypes.size(); ++i) {
                            String argType = (String)argTypes.get(i);
                            String argName = i < argNames.size() ? (String)argNames.get(i) : null;
                            ImmutableArgumentMeta argumentMeta = ImmutableArgumentMeta.builder().type(argType).name(Optional.ofNullable(argName)).build();
                            args.add(argumentMeta);
                        }
                    }
                    ColumnRef commentKey = this.asProcedureKey(name, argTypesString);
                    Optional<String> comment = Optional.ofNullable(comments.get(commentKey));
                    ImmutableProcedureMeta procedureMeta = ImmutableProcedureMeta.builder().name(name).comment(comment).args(args).build();
                    builder.add((Object)procedureMeta);
                }
            }
        });
        ImmutableList result = builder.build();
        return result;
    }

    protected Multimap<ColumnRef, ColumnRef> readForeignKeys(String schema) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        this.doWork(connection -> {
            String sql = String.format("select     contrainte.conname as foreign_key_name,     local_class.relname as table,     local_attribute.attname as column,     foreign_class.relname as foreign_table,     foreign_attribute.attname as foreign_column  from    (select         unnest(con1.conkey) as \"parent\",         unnest(con1.confkey) as \"child\",         con1.confrelid,         con1.conrelid,         con1.conname     from         pg_class cl         join pg_namespace ns             on cl.relnamespace = ns.oid         join pg_constraint con1             on con1.conrelid = cl.oid     where         ns.nspname = '%s'         and con1.contype = 'f'    ) contrainte    join pg_class foreign_class        on foreign_class.oid = contrainte.confrelid    join pg_attribute foreign_attribute        on foreign_attribute.attrelid = contrainte.confrelid        and foreign_attribute.attnum = contrainte.child    join pg_class local_class    \t   on local_class.oid = contrainte.conrelid    join pg_attribute local_attribute        on local_attribute.attrelid = contrainte.conrelid        and local_attribute.attnum = contrainte.parent    order by local_class.relname asc,             local_attribute.attname asc        ;\n", schema);
            try (PreparedStatement statement = connection.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String table = resultSet.getString("table");
                    String colonne = resultSet.getString("column");
                    String foreignTable = resultSet.getString("foreign_table");
                    String foreignColonne = resultSet.getString("foreign_column");
                    ColumnRef source = ColumnRef.forColumn(table, colonne);
                    ColumnRef reference = ColumnRef.forColumn(foreignTable, foreignColonne);
                    result.put((Object)source, (Object)reference);
                }
            }
        });
        return result;
    }

    protected ImmutableSet<ColumnRef> readPrimaryKeys(String schema) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.doWork(connection -> {
            String sql = String.format("select     con.conname as primary_key_name,     table_class.relname as table,     column_attribute.attname as column from    (select         unnest(con1.conkey) as \"parent\",         con1.conrelid,         con1.conname     from         pg_class cl         join pg_namespace ns             on cl.relnamespace = ns.oid         join pg_constraint con1             on con1.conrelid = cl.oid     where         ns.nspname = '%s'         and con1.contype = 'p'    ) con    join pg_class table_class        on table_class.oid = con.conrelid    join pg_attribute column_attribute        on column_attribute.attrelid = con.conrelid        and column_attribute.attnum = con.parent    ; ", schema);
            try (PreparedStatement statement = connection.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String table = resultSet.getString("table");
                    String colonne = resultSet.getString("column");
                    ColumnRef source = ColumnRef.forColumn(table, colonne);
                    builder.add((Object)source);
                }
            }
        });
        ImmutableSet result = builder.build();
        return result;
    }

    protected ImmutableSet<ColumnRef> readUniqueColumns(String schema) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.doWork(connection -> {
            String sql = String.format("select     con.conname as primary_key_name,     table_class.relname as table,     column_attribute.attname as column from    (select         unnest(con1.conkey) as \"parent\",         con1.conrelid,         con1.conname     from         pg_class cl         join pg_namespace ns             on cl.relnamespace = ns.oid         join pg_constraint con1             on con1.conrelid = cl.oid     where         ns.nspname = '%s'         and con1.contype = 'u'    ) con    join pg_class table_class        on table_class.oid = con.conrelid    join pg_attribute column_attribute        on column_attribute.attrelid = con.conrelid        and column_attribute.attnum = con.parent    ; ", schema);
            try (PreparedStatement statement = connection.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String table = resultSet.getString("table");
                    String colonne = resultSet.getString("column");
                    ColumnRef source = ColumnRef.forColumn(table, colonne);
                    builder.add((Object)source);
                }
            }
        });
        ImmutableSet result = builder.build();
        return result;
    }

    protected ImmutableList<TableMeta> readTableMetas(String schema, ImmutableList<CustomTypeMeta> customTypes) {
        Map<ColumnRef, String> comments = this.readTableAndViewComments(schema);
        ImmutableSet<ColumnRef> primaryKeys = this.readPrimaryKeys(schema);
        ImmutableSet<ColumnRef> uniqueColumns = this.readUniqueColumns(schema);
        Multimap<ColumnRef, ColumnRef> foreignKeys = this.readForeignKeys(schema);
        ImmutableList<TableMeta> result = this.readTableMetas("TABLE", schema, comments, (Set<ColumnRef>)primaryKeys, (Set<ColumnRef>)uniqueColumns, foreignKeys, customTypes);
        return result;
    }

    protected ImmutableList<TableMeta> readViewMetas(String schema, ImmutableList<CustomTypeMeta> customTypes) {
        Map<ColumnRef, String> comments = this.readTableAndViewComments(schema);
        ImmutableSet<ColumnRef> primaryKeys = this.readPrimaryKeys(schema);
        ImmutableSet<ColumnRef> uniqueColumns = this.readUniqueColumns(schema);
        Multimap<ColumnRef, ColumnRef> foreignKeys = this.readForeignKeys(schema);
        ImmutableList<TableMeta> result = this.readTableMetas("VIEW", schema, comments, (Set<ColumnRef>)primaryKeys, (Set<ColumnRef>)uniqueColumns, foreignKeys, customTypes);
        return result;
    }

    protected Map<String, String> readCustomTypesComments(String schema) {
        HashMap<String, String> result = new HashMap<String, String>();
        this.doWork(connection -> {
            String sql = String.format("  SELECT t.typname AS type,        d.description AS comment FROM pg_type t  INNER JOIN pg_catalog.pg_namespace n    ON n.oid = t.typnamespace   AND n.nspname = '%s' INNER JOIN pg_catalog.pg_description d   ON d.objoid = (n.nspname || '.' || t.typname)::regtype::oid   AND d.objsubid = 0 -- Pour ne pas avoir les commentaires sur les valeurs des types WHERE (t.typrelid = 0        OR          (SELECT c.relkind = 'c'           FROM pg_catalog.pg_class c           WHERE c.oid = t.typrelid))  AND NOT EXISTS      (SELECT 1       FROM pg_catalog.pg_type el       WHERE el.oid = t.typelem         AND el.typarray = t.oid) ; ", schema);
            try (PreparedStatement statement = connection.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String name = resultSet.getString("type");
                    String comment = resultSet.getString("comment");
                    if (!StringUtils.isNotEmpty((CharSequence)comment)) continue;
                    result.put(name, comment);
                }
            }
        });
        return result;
    }

    protected ImmutableList<CustomTypeMeta> readCustomTypes(String schema, Function<String, Class<? extends Enum>> enumResolver) {
        Map<String, String> comments = this.readCustomTypesComments(schema);
        ImmutableList.Builder builder = ImmutableList.builder();
        this.doWork(connection -> {
            String sql = String.format(" SELECT t.typname AS type  FROM pg_type t  LEFT JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace  WHERE (t.typrelid = 0        OR          (SELECT c.relkind = 'c'           FROM pg_catalog.pg_class c           WHERE c.oid = t.typrelid))  AND NOT EXISTS      (SELECT 1       FROM pg_catalog.pg_type el       WHERE el.oid = t.typelem         AND el.typarray = t.oid)  AND n.nspname = '%s';", schema);
            try (PreparedStatement statement = connection.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String name = resultSet.getString("type");
                    Optional<String> comment = Optional.ofNullable(comments.get(name));
                    Class foundClass = (Class)enumResolver.apply(name);
                    Optional<Class> enumMatching = Optional.ofNullable(foundClass);
                    LinkedList<String> values = new LinkedList<String>();
                    if (enumMatching.isPresent()) {
                        Class aClass = enumMatching.get();
                        try {
                            Method valuesMethod = aClass.getMethod("values", new Class[0]);
                            Object invokeResult = valuesMethod.invoke(null, new Object[0]);
                            Enum[] result = (Enum[])invokeResult;
                            Arrays.stream(result).map(Enum::name).forEach(values::add);
                        }
                        catch (Exception eee) {
                            log.error((Object)"Unable to read enum values", (Throwable)eee);
                        }
                    } else if (log.isWarnEnabled()) {
                        log.warn((Object)("No enum found for name: " + name));
                    }
                    ImmutableCustomTypeMeta customType = ImmutableCustomTypeMeta.builder().name(name).enumEquivalence(enumMatching).values(values).comment(comment).build();
                    builder.add((Object)customType);
                }
            }
        });
        ImmutableList result = builder.build();
        return result;
    }

    protected Function<String, Class<? extends Enum>> packageEnumResolver() {
        Object enums = StringUtils.isNotEmpty((CharSequence)this.packageForEnumResolver) ? new Reflections(this.packageForEnumResolver, new Scanner[0]).getSubTypesOf(Enum.class) : ImmutableSet.of();
        Converter camelToUnderscore = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);
        ImmutableMap enumsIndex = Maps.uniqueIndex((Iterable)enums, e -> (String)camelToUnderscore.convert((Object)e.getSimpleName()));
        Function<String, Class<? extends Enum>> result = s -> (Class)enumsIndex.get((Object)s.toLowerCase());
        return result;
    }

    public DatabaseMeta buildMeta(String schema) {
        ImmutableList<CustomTypeMeta> customTypes = this.readCustomTypes(schema, this.packageEnumResolver());
        ImmutableList<TableMeta> tables = this.readTableMetas(schema, customTypes);
        ImmutableList<TableMeta> views = this.readViewMetas(schema, customTypes);
        ImmutableList<ProcedureMeta> procedures = this.readProcedureMetas(schema);
        ImmutableDatabaseMeta result = ImmutableDatabaseMeta.builder().schema(schema).customTypes((Iterable<? extends CustomTypeMeta>)customTypes).tables((Iterable<? extends TableMeta>)tables).views((Iterable<? extends TableMeta>)views).procedures((Iterable<? extends ProcedureMeta>)procedures).build();
        return result;
    }
}

