/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.db.meta;

import java.util.Optional;
import org.immutables.value.Value;
import org.nuiton.db.meta.ImmutableColumnRef;

@Value.Immutable
public interface ColumnRef {
    public String getTable();

    public Optional<String> getColumn();

    public static ColumnRef forTable(String table) {
        ImmutableColumnRef result = ImmutableColumnRef.builder().table(table.toLowerCase()).build();
        return result;
    }

    public static ColumnRef forColumn(String table, String column) {
        ImmutableColumnRef result = ImmutableColumnRef.builder().table(table.toLowerCase()).column(column.toLowerCase()).build();
        return result;
    }

    default public String pretty() {
        String result = String.format("%s(%s)", this.getTable(), this.getColumn().orElse(null));
        return result;
    }
}

