/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.db.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.nuiton.db.meta.CustomTypeMeta;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CustomTypeMeta", generator="Immutables")
@Immutable
public final class ImmutableCustomTypeMeta
implements CustomTypeMeta {
    private final String name;
    @Nullable
    private final String comment;
    @Nullable
    private final Class<? extends Enum> enumEquivalence;
    private final ImmutableList<String> values;

    private ImmutableCustomTypeMeta(String name, @Nullable String comment, @Nullable Class<? extends Enum> enumEquivalence, ImmutableList<String> values) {
        this.name = name;
        this.comment = comment;
        this.enumEquivalence = enumEquivalence;
        this.values = values;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    @Override
    public Optional<Class<? extends Enum>> getEnumEquivalence() {
        return Optional.ofNullable(this.enumEquivalence);
    }

    @Override
    public ImmutableList<String> getValues() {
        return this.values;
    }

    public final ImmutableCustomTypeMeta withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableCustomTypeMeta(newValue, this.comment, this.enumEquivalence, this.values);
    }

    public final ImmutableCustomTypeMeta withComment(String value) {
        String newValue = Objects.requireNonNull(value, "comment");
        if (Objects.equals(this.comment, newValue)) {
            return this;
        }
        return new ImmutableCustomTypeMeta(this.name, newValue, this.enumEquivalence, this.values);
    }

    public final ImmutableCustomTypeMeta withComment(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.comment, value)) {
            return this;
        }
        return new ImmutableCustomTypeMeta(this.name, value, this.enumEquivalence, this.values);
    }

    public final ImmutableCustomTypeMeta withEnumEquivalence(Class<? extends Enum> value) {
        Class<? extends Enum> newValue = Objects.requireNonNull(value, "enumEquivalence");
        if (this.enumEquivalence == newValue) {
            return this;
        }
        return new ImmutableCustomTypeMeta(this.name, this.comment, newValue, this.values);
    }

    public final ImmutableCustomTypeMeta withEnumEquivalence(Optional<? extends Class<? extends Enum>> optional) {
        Class value = optional.orElse(null);
        if (this.enumEquivalence == value) {
            return this;
        }
        return new ImmutableCustomTypeMeta(this.name, this.comment, value, this.values);
    }

    public final ImmutableCustomTypeMeta withValues(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCustomTypeMeta(this.name, this.comment, this.enumEquivalence, (ImmutableList<String>)newValue);
    }

    public final ImmutableCustomTypeMeta withValues(Iterable<String> elements) {
        if (this.values == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCustomTypeMeta(this.name, this.comment, this.enumEquivalence, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCustomTypeMeta && this.equalTo((ImmutableCustomTypeMeta)another);
    }

    private boolean equalTo(ImmutableCustomTypeMeta another) {
        return this.name.equals(another.name) && Objects.equals(this.comment, another.comment) && Objects.equals(this.enumEquivalence, another.enumEquivalence) && this.values.equals(another.values);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.comment);
        h += (h << 5) + Objects.hashCode(this.enumEquivalence);
        h += (h << 5) + this.values.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CustomTypeMeta").omitNullValues().add("name", (Object)this.name).add("comment", (Object)this.comment).add("enumEquivalence", this.enumEquivalence).add("values", this.values).toString();
    }

    public static ImmutableCustomTypeMeta copyOf(CustomTypeMeta instance) {
        if (instance instanceof ImmutableCustomTypeMeta) {
            return (ImmutableCustomTypeMeta)instance;
        }
        return ImmutableCustomTypeMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CustomTypeMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        @Nullable
        private String comment;
        @Nullable
        private Class<? extends Enum> enumEquivalence;
        private ImmutableList.Builder<String> values = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CustomTypeMeta instance) {
            Optional<Class<? extends Enum>> enumEquivalenceOptional;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            Optional<String> commentOptional = instance.getComment();
            if (commentOptional.isPresent()) {
                this.comment(commentOptional);
            }
            if ((enumEquivalenceOptional = instance.getEnumEquivalence()).isPresent()) {
                this.enumEquivalence(enumEquivalenceOptional);
            }
            this.addAllValues((Iterable<String>)instance.getValues());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "comment");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder comment(Optional<String> comment) {
            this.comment = comment.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enumEquivalence(Class<? extends Enum> enumEquivalence) {
            this.enumEquivalence = Objects.requireNonNull(enumEquivalence, "enumEquivalence");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enumEquivalence(Optional<? extends Class<? extends Enum>> enumEquivalence) {
            this.enumEquivalence = enumEquivalence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValues(String element) {
            this.values.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValues(String ... elements) {
            this.values.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder values(Iterable<String> elements) {
            this.values = ImmutableList.builder();
            return this.addAllValues(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllValues(Iterable<String> elements) {
            this.values.addAll(elements);
            return this;
        }

        public ImmutableCustomTypeMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCustomTypeMeta(this.name, this.comment, this.enumEquivalence, this.values.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CustomTypeMeta, some of required attributes are not set " + attributes;
        }
    }
}

